/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.ConnectionChannel;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Media
implements Command {
    private static final long serialVersionUID = 1L;
    private static final int IMG_MAX_SIZE = 0xFFFFFF;
    private File mediaFile = null;

    private static String getHex(int i, int bytes) {
        String formatStr = String.format("%%0%dX", bytes * 2);
        return String.format(formatStr, i);
    }

    public Media(File mediaFile) {
        if (mediaFile == null) {
            throw new IllegalArgumentException("mediaFile is null");
        }
        if (!mediaFile.exists()) {
            throw new IllegalArgumentException("File not found");
        }
        if (mediaFile.length() > 0xFFFFFFL) {
            throw new IllegalArgumentException("Image is too big");
        }
        this.mediaFile = mediaFile;
    }

    public final File getMediaFile() {
        return this.mediaFile;
    }

    @Override
    public final void write(ConnectionChannel channel) throws IOException {
        File file = this.getMediaFile();
        byte[] imageSize = String.format("%06X", file.length()).getBytes();
        DataBuffer dbf = new DataBuffer();
        dbf.putString("#sendmedia");
        dbf.put(imageSize[0]);
        dbf.put(imageSize[1]);
        dbf.put(imageSize[2]);
        dbf.put(imageSize[3]);
        dbf.put(imageSize[4]);
        dbf.put(imageSize[5]);
        dbf.putString(file.getName());
        channel.write(dbf.readBytes());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] arrayGif = Files.readAllBytes(Paths.get(file.toURI()));
        channel.write(arrayGif);
    }

    public String toString() {
        return String.format("%s {file: %s, fileSize: %s}", "#img", this.getMediaFile().getName(), Media.getHex((int)this.getMediaFile().length(), 1));
    }

    public static byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sendBuf;
    }
}

