/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ParamConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private boolean dhcpEnabled;
    private byte serverSearch;

    public ParamConfig() {
        super("#paramconfig");
    }

    public ParamConfig(boolean dhcpEnabled, byte serverSearch) {
        this();
        this.dhcpEnabled = dhcpEnabled;
        this.serverSearch = serverSearch;
    }

    public ParamConfig(DataBuffer dataBuffer) throws IncompleteCommandException {
        this();
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataSize = 0;
        try {
            if (bb.remaining() - dataSize == 0) {
                throw new IncompleteCommandException(new Throwable("#paramconfig came without parameters"));
            }
            byte dhcpFromCommand = bb.get();
            if (dhcpFromCommand == 1 || dhcpFromCommand == 49) {
                this.dhcpEnabled = true;
                ++dataSize;
            } else {
                this.dhcpEnabled = false;
                ++dataSize;
            }
            if (bb.remaining() - dataSize > 0) {
                this.serverSearch = CommUtils.getRealByte(bb.get());
                ++dataSize;
            }
            dataBuffer.readBytes(++dataSize);
        }
        catch (BufferUnderflowException ex) {
            throw new IncompleteCommandException(ex);
        }
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        buffer.put(CommUtils.getProtocolByte(this.dhcpEnabled ? (byte)49 : 48));
        buffer.put(CommUtils.getProtocolByte(this.serverSearch));
        return buffer.readBytes();
    }

    public boolean isDhcpEnabled() {
        return this.dhcpEnabled;
    }

    public byte getServerSearch() {
        return this.serverSearch;
    }

    @Override
    public String toString() {
        return String.format("%s {dhcpEnabled: %s, serverSearch: %d}", this.getId(), this.isDhcpEnabled(), this.getServerSearch());
    }
}

