/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.PassParameter;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PlayAudioWithMsg
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final int AUDIO_MAX_SIZE = 68000;
    private static final int AUDIO_MIN_SIZE = 16000;
    private static final int MAX_AUDIO_TIME = 7;
    private static final int MIN_AUDIO_TIME = 2;
    private static final int MAX_AUDIO_VOLUME = 3;
    private static final int MIN_AUDIO_VOLUME = 0;
    private static final String NOT_FOUND = "nfound";
    private int audioSize;
    private short audioTime;
    private short audioVolume;
    private File audio;
    private String description;
    private String price1;
    private boolean productExist;

    public PlayAudioWithMsg(String id) {
        super("#playaudiowithmessage");
    }

    public int getAudioSize() {
        return this.audioSize;
    }

    public void setAudioSize(int audioSize) {
        this.audioSize = audioSize;
    }

    public short getAudioTime() {
        return this.audioTime;
    }

    public void setAudioTime(short audioTime) {
        this.audioTime = audioTime;
    }

    public short getAudioVolume() {
        return this.audioVolume;
    }

    public void setAudioVolume(short audioVolume) {
        this.audioVolume = audioVolume;
    }

    public File getAudio() {
        return this.audio;
    }

    public void setAudio(File audio) {
        this.audio = audio;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrice1() {
        return this.price1;
    }

    public void setAudioHeader(boolean productExist, File audio, short audioTime, short audioVolume, String description, String price) {
        File finalAudio;
        this.productExist = productExist;
        this.audioTime = audioTime;
        this.audioVolume = audioVolume;
        if (productExist) {
            this.description = description;
            this.price1 = price;
        }
        this.audio = finalAudio = this.verifyAudioFile(audio);
    }

    private File verifyAudioFile(File audio) {
        boolean needNewAudio = false;
        String msgInfo = " An audio with the description \"Audio description unavailable\" will be sent.";
        if (audio == null) {
            Log.warning(J18N.tr("Audio file is null.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (!audio.exists()) {
            Log.warning(J18N.tr("Audio not found.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (audio.length() > 68000L) {
            Log.warning(J18N.tr("Audio is too big.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (audio.length() < 16000L) {
            Log.warning(J18N.tr("Audio is too small.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (this.audioTime > 7) {
            Log.warning(J18N.tr("Audio is too long.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (this.audioTime < 2) {
            Log.warning(J18N.tr("Audio is too short.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (this.audioVolume > 3 || this.audioVolume < 0) {
            Log.warning(J18N.tr("Invalid audio volume.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (PassParameter.isInvalidAmount()) {
            Log.warning(J18N.tr("Invalid number of characters.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
        }
        if (needNewAudio) {
            File audioFile = null;
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioNotFoundG2(GenerateAudioImpl.fileUnavailable, NOT_FOUND);
                if (!returnValue.isFromICTS()) {
                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                }
                audioFile = returnValue.getAudioFinalFile();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            return audioFile;
        }
        return audio;
    }

    public static byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sendBuf;
    }

    private static void putString(DataBuffer buffer, String str) {
        try {
            buffer.putString(str, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] getSerializedPayload() {
        byte[] audioSize = String.format("%06X", this.getAudio().length()).getBytes();
        byte[] time = String.format("%01X", this.getAudioTime()).getBytes();
        byte[] volume = String.format("%01X", this.getAudioVolume()).getBytes();
        String description = this.getDescription();
        String price = this.getPrice1();
        DataBuffer dataBuffer = new DataBuffer();
        dataBuffer.put(audioSize[0]);
        dataBuffer.put(audioSize[1]);
        dataBuffer.put(audioSize[2]);
        dataBuffer.put(audioSize[3]);
        dataBuffer.put(audioSize[4]);
        dataBuffer.put(audioSize[5]);
        dataBuffer.put(time[0]);
        dataBuffer.put(volume[0]);
        if (!this.productExist || description.isEmpty()) {
            PlayAudioWithMsg.putString(dataBuffer, NOT_FOUND);
        } else {
            if (description.length() < 10) {
                byte[] descSize = String.format("%02X", description.length()).getBytes();
                dataBuffer.put(descSize[0]);
                dataBuffer.put(descSize[1]);
                PlayAudioWithMsg.putString(dataBuffer, description);
            } else {
                String[] auxDesc = String.valueOf(description.length()).split("");
                int descByte1 = Integer.parseInt(auxDesc[0]) + 48;
                int descByte2 = Integer.parseInt(auxDesc[1]) + 48;
                dataBuffer.put((byte)descByte1);
                dataBuffer.put((byte)descByte2);
                PlayAudioWithMsg.putString(dataBuffer, description);
            }
            if (price.length() < 10) {
                byte[] priceSize = String.format("%02X", price.length()).getBytes();
                dataBuffer.put(priceSize[0]);
                dataBuffer.put(priceSize[1]);
                PlayAudioWithMsg.putString(dataBuffer, price);
            } else {
                String[] auxPrice = String.valueOf(price.length()).split("");
                int priceByte1 = Integer.parseInt(auxPrice[0]) + 48;
                int priceByte2 = Integer.parseInt(auxPrice[1]) + 48;
                dataBuffer.put((byte)priceByte1);
                dataBuffer.put((byte)priceByte2);
                PlayAudioWithMsg.putString(dataBuffer, price);
            }
        }
        return dataBuffer.readBytes();
    }
}

