/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.ByteBuffer;

public class REConf02
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final Config02.ConfigParams params = new Config02.ConfigParams();

    private REConf02() {
        super("#reconf02");
    }

    public REConf02(String serverIp, String terminalIp, String netmask, String line1, String line2, String line3, String line4, int exhibTime) {
        this();
        this.params.serverIp = serverIp;
        this.params.terminalIp = terminalIp;
        this.params.netmask = netmask;
        this.params.line1 = line1;
        this.params.line2 = line2;
        this.params.line3 = line3;
        this.params.line4 = line4;
        this.params.exhibTime = exhibTime;
    }

    public REConf02(Config02.ConfigParams params) {
        this(params.serverIp, params.terminalIp, params.netmask, params.line1, params.line2, params.line3, params.line4, params.exhibTime);
    }

    public REConf02(ByteBuffer buffer) {
        this();
        this.params.serverIp = CommUtils.getProtocolString(buffer);
        this.params.terminalIp = CommUtils.getProtocolString(buffer);
        this.params.netmask = CommUtils.getProtocolString(buffer);
        this.params.line1 = CommUtils.getProtocolString(buffer);
        this.params.line2 = CommUtils.getProtocolString(buffer);
        this.params.line3 = CommUtils.getProtocolString(buffer);
        this.params.line4 = CommUtils.getProtocolString(buffer);
        this.params.exhibTime = CommUtils.getProtocolByte(buffer.get());
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        this.checkIfIsComplete();
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.serverIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.terminalIp);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.netmask);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line1);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line2);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line3);
        CommUtils.putProtocolStringIntoBuffer(buffer, this.params.line4);
        buffer.put(CommUtils.getProtocolByte((byte)this.params.exhibTime));
        buffer.put((byte)0);
        return buffer.readBytes();
    }

    private void checkIfIsComplete() {
        if (this.params.serverIp == null) {
            throw new RuntimeException("Server Ip is null");
        }
        if (this.params.terminalIp == null) {
            throw new RuntimeException("Terminal Ip is null");
        }
        if (this.params.netmask == null) {
            throw new RuntimeException("netmask is empty.");
        }
        if (this.params.line1 == null) {
            throw new RuntimeException("line 1 is empty.");
        }
        if (this.params.line2 == null) {
            throw new RuntimeException("line 2 is empty.");
        }
        if (this.params.line3 == null) {
            throw new RuntimeException("line 3 is empty.");
        }
        if (this.params.line4 == null) {
            throw new RuntimeException("line 4 is empty.");
        }
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.getId(), this.params.toString());
    }
}

