/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class UpdConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private static final String NOT_SUPPORTED = "N\u00e3o suportado";
    private final String gateway;
    private final String terminalName;

    public UpdConfig(String gateway, String terminalName) {
        super("#updconfig");
        if (gateway == null || gateway.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty gateway");
        }
        if (terminalName == null || terminalName.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty terminal name");
        }
        this.gateway = gateway;
        this.terminalName = terminalName;
    }

    public UpdConfig(DataBuffer dataBuffer) throws IncompleteCommandException {
        super("#updconfig");
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        int dataSize = 0;
        try {
            this.gateway = CommUtils.getProtocolString(bb);
            dataSize += this.gateway.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            String discardedString = CommUtils.getProtocolString(bb);
            dataSize += discardedString.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            this.terminalName = CommUtils.getProtocolString(bb);
            dataSize += this.terminalName.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            discardedString = CommUtils.getProtocolString(bb);
            dataSize += discardedString.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            discardedString = CommUtils.getProtocolString(bb);
            dataSize += discardedString.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            discardedString = CommUtils.getProtocolString(bb);
            dataSize += discardedString.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length + 1;
            bb.get();
            dataBuffer.readBytes(++dataSize);
        }
        catch (BufferUnderflowException ex) {
            throw new IncompleteCommandException(ex);
        }
    }

    public final String getGateway() {
        return this.gateway;
    }

    public final String getTerminalName() {
        return this.terminalName;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer dataBuffer = new DataBuffer();
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, this.getGateway());
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, NOT_SUPPORTED);
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, this.getTerminalName());
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, NOT_SUPPORTED);
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, NOT_SUPPORTED);
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, NOT_SUPPORTED);
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, NOT_SUPPORTED);
        dataBuffer.put((byte)0);
        return dataBuffer.readBytes();
    }
}

