/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.WiFiSecurity;
import br.com.gertec.tc.server.protocol.WifiMode;
import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class WlanConfig
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final ConfigParams params = new ConfigParams();

    public WlanConfig(boolean enabled, WifiMode wifiMode, String ssid, byte channel, WiFiSecurity wifiSecurity, String wepKey) {
        super("#wlanconfig");
        this.params.enabled = enabled;
        this.params.wifiMode = wifiMode;
        this.params.ssid = ssid;
        this.params.channel = channel;
        this.params.wifiSecurity = wifiSecurity;
        this.params.wepKey = wepKey;
    }

    public WlanConfig(ConfigParams params) {
        this(params.enabled, params.wifiMode, params.ssid, params.channel, params.wifiSecurity, params.wepKey);
    }

    public WlanConfig(DataBuffer dataBuffer) throws IncompleteCommandException {
        super("#wlanconfig");
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        try {
            byte b = bb.get();
            b = CommUtils.getRealByte(b);
            this.params.enabled = b == 1;
            b = CommUtils.getRealByte(bb.get());
            this.params.wifiMode = WifiMode.fromSc501Val(b);
            this.params.ssid = CommUtils.getProtocolString(bb);
            this.params.channel = b = bb.get();
            b = bb.get();
            this.params.wifiSecurity = WiFiSecurity.fromSc501Val(b);
            this.params.wepKey = CommUtils.getProtocolString(bb);
            b = bb.get();
            dataBuffer.clear();
        }
        catch (BufferUnderflowException ex) {
            throw new IncompleteCommandException(ex);
        }
    }

    public final ConfigParams getParams() {
        return this.params;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer dataBuffer = new DataBuffer();
        dataBuffer.put(this.params.enabled ? (byte)1 : 0);
        dataBuffer.put(CommUtils.getProtocolByte(this.params.wifiMode.getSc501Value()));
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, this.params.ssid);
        dataBuffer.put(this.params.channel);
        dataBuffer.put(this.params.wifiSecurity.getSc501Value());
        CommUtils.putProtocolStringIntoBuffer(dataBuffer, this.params.wepKey);
        dataBuffer.put((byte)0);
        return dataBuffer.readBytes();
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.getId(), this.getParams().toString());
    }

    public static class ConfigParams {
        public boolean enabled = false;
        public WifiMode wifiMode;
        public String ssid;
        public byte channel;
        public WiFiSecurity wifiSecurity;
        public String wepKey;

        public ConfigParams() {
        }

        public ConfigParams(ConfigParams other) {
            this.enabled = other.enabled;
            this.wifiMode = other.wifiMode;
            this.ssid = other.ssid;
            this.channel = other.channel;
            this.wifiSecurity = other.wifiSecurity;
            this.wepKey = other.wepKey;
        }

        public String toString() {
            return String.format("{enabled: %s, wifiMode: %s, ssid: %s, wifiSecurity: %s, wepKey: %s}", this.enabled, this.wifiMode.name(), this.ssid, this.wifiSecurity == null ? "null" : this.wifiSecurity.name(), this.wepKey);
        }
    }
}

