/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504;

import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.commands.IDCleanExternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.IDCleanInternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.IDContinue;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetMACAddress;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetVersion;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGoADV;
import br.com.gertec.tc.server.protocol.sc504.commands.IDQueryProcessFailure;
import br.com.gertec.tc.server.protocol.sc504.commands.IDReloadADV;
import br.com.gertec.tc.server.protocol.sc504.commands.IDReloadPreImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.IDSetSensor;
import br.com.gertec.tc.server.protocol.sc504.commands.IDStopADV;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbReadScanner;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbSetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvAlwaysLive;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDeleteADV;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDeletePreImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetUID;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvLive;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowFrame;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.protocol.sc504.commands.IDwGetIdentify;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDCleanExternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDCleanInternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDContinue;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDDeleteLocalMedia;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetMACAddress;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetVersion;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGoADV;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDReloadADV;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDReloadPreImg;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDRestart;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetSensor;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDShowLocalMedia;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDStopADV;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbReadScanner;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbSetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvAlwaysLive;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvDeleteADV;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvDeletePreImg;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetUID;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvLive;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvPlayAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvRecvFile;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSendFile;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvSetSetupWiFiTc504;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvShowFrame;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvShowText;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDwGetIdentify;
import br.com.gertec.tc.server.protocol.sc504.commands.Sc504CommDefs;
import br.com.gertec.tc.server.protocol.sc504.commands.TcUnknownCommand;
import br.com.gertec.tc.server.util.FileUtilities;
import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.event.comm.AbstractHeapCommand;
import br.org.reconcavo.event.comm.ByteOrder;
import br.org.reconcavo.event.comm.CommandBuilder;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.event.comm.SimpleCommand;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class Sc504CommandBuilder
implements CommandBuilder {
    private static final byte STX = 2;
    private Short currentId = null;
    private Integer dataLength = null;
    private TcFileReceiver fileReceiver = new TcFileReceiver();
    private TerminalType terminalType = null;

    protected ByteOrder getByteOrder() {
        return Sc504CommDefs.DEFAULT_BYTE_ORDER;
    }

    public TerminalType getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(TerminalType terminalType) {
        this.terminalType = terminalType;
    }

    @Override
    public boolean canBuild(DataBuffer dataBuffer) {
        ByteOrder byteOrder = this.getByteOrder();
        if (this.currentId == null) {
            if (dataBuffer.available() >= 7) {
                byte stx = dataBuffer.readByte();
                if (stx != 2) {
                    throw new RuntimeException("Bad STX: " + stx);
                }
                this.currentId = dataBuffer.readShort(byteOrder);
                this.dataLength = dataBuffer.readInt(byteOrder);
                if (this.currentId != 98) {
                    return dataBuffer.available() >= this.dataLength;
                }
            } else {
                return false;
            }
        }
        if (this.currentId != 98) {
            return dataBuffer.available() >= this.dataLength;
        }
        RIDvRecvFile response = this.fileReceiver.checkFileComplete(this.dataLength, dataBuffer);
        if (response != null) {
            this.reset();
            this.onFileReceived(response);
        }
        return false;
    }

    @Override
    public void reset() {
        this.currentId = null;
        this.dataLength = null;
    }

    @Override
    public final AbstractHeapCommand getCommand(DataBuffer dataBuffer) {
        byte[] data = dataBuffer.readBytes(this.dataLength);
        try {
            SimpleCommand command;
            SimpleCommand simpleCommand = command = this.getCommand(this.currentId, data);
            return simpleCommand;
        }
        catch (Throwable error) {
            throw new RuntimeException(String.format("Error building command with id %d", this.currentId), error);
        }
        finally {
            this.reset();
        }
    }

    protected SimpleCommand getCommand(short id, byte[] data) {
        switch (id) {
            case 19: {
                return new IDwGetIdentify();
            }
            case 20: {
                return new RIDwGetIdentify(data);
            }
            case 21: {
                return new IDContinue(data);
            }
            case 22: {
                return new RIDContinue();
            }
            case 17: {
                return new IDvLive();
            }
            case 18: {
                return new RIDvLive();
            }
            case 216: {
                return new IDGetVersion();
            }
            case 217: {
                return new RIDGetVersion(data);
            }
            case 27: {
                return new IDvGetUID();
            }
            case 28: {
                return new RIDvGetUID(data);
            }
            case 218: {
                return new IDGetMACAddress();
            }
            case 219: {
                return new RIDGetMACAddress(data);
            }
            case 29: {
                return new IDvAlwaysLive(data);
            }
            case 30: {
                return new RIDvAlwaysLive();
            }
            case 43: {
                return new IDGoADV();
            }
            case 44: {
                return new RIDGoADV(data);
            }
            case 45: {
                return new IDStopADV();
            }
            case 46: {
                return new RIDStopADV(data);
            }
            case 41: {
                return new IDvGetTimeExhib();
            }
            case 42: {
                return new RIDvGetTimeExhib(data);
            }
            case 39: {
                return new IDbSetTimeExhib(data);
            }
            case 40: {
                return new RIDbSetTimeExhib(data);
            }
            case 101: {
                return new IDvDeleteADV();
            }
            case 102: {
                return new RIDvDeleteADV(data);
            }
            case 117: {
                return new IDReloadADV();
            }
            case 118: {
                return new RIDReloadADV(data);
            }
            case 23: {
                return new IDvSetSetupTCP(data);
            }
            case 24: {
                return new RIDvSetSetupTCP(data);
            }
            case 25: {
                return new IDvGetSetupTCP();
            }
            case 26: {
                return new RIDvGetSetupTCP(data);
            }
            case 153: {
                if (this.getTerminalType() != null && this.getTerminalType() == TerminalType.TC_504) {
                    return new IDvSetSetupWiFiTc504(data);
                }
                return new IDvGetSetupWiFi();
            }
            case 154: {
                if (this.getTerminalType() != null && this.getTerminalType() == TerminalType.TC_504) {
                    return new RIDvSetSetupWiFiTc504(data);
                }
                return new RIDvGetSetupWiFi(data);
            }
            case 151: {
                if (this.getTerminalType() != null && this.getTerminalType() == TerminalType.TC_504) {
                    return new IDvGetSetupWiFiTc504();
                }
                return new IDvSetSetupWiFi(data);
            }
            case 152: {
                if (this.getTerminalType() != null && this.getTerminalType() == TerminalType.TC_504) {
                    return new RIDvGetSetupWiFiTc504(data);
                }
                return new RIDvSetSetupWiFi(data);
            }
            case 89: {
                return new IDbReadScanner(data);
            }
            case 90: {
                return new RIDbReadScanner();
            }
            case 186: {
                return new IDCleanInternalMem();
            }
            case 187: {
                return new RIDCleanInternalMem(data);
            }
            case 188: {
                return new IDCleanExternalMem();
            }
            case 189: {
                return new RIDCleanExternalMem(data);
            }
            case 33: {
                return new IDvDispClear(data);
            }
            case 34: {
                return new RIDvDispClear(data);
            }
            case 35: {
                return new IDvShowText(data);
            }
            case 36: {
                return new RIDvShowText(data);
            }
            case 37: {
                return new IDvShowImg(data);
            }
            case 38: {
                return new RIDvShowImg();
            }
            case 168: {
                return new IDSetSensor(data);
            }
            case 169: {
                return new RIDSetSensor(data);
            }
            case 173: {
                return new RIDSetAudio(data);
            }
            case 177: {
                return new RIDSetVolume(data);
            }
            case 181: {
                return new RIDSetBrightness(data);
            }
            case 171: {
                return new RIDGetSensorStatus(data);
            }
            case 175: {
                return new RIDGetAudioStatus(data);
            }
            case 179: {
                return new RIDGetVolume(data);
            }
            case 183: {
                return new RIDGetBrightness(data);
            }
            case 122: {
                return new RIDRestart(data);
            }
            case 100: {
                return new RIDvSendFile(data);
            }
            case 167: {
                return new RIDShowLocalMedia(data);
            }
            case 185: {
                return new RIDDeleteLocalMedia(data);
            }
            case 129: {
                return new IDvShowFrame(data);
            }
            case 130: {
                return new RIDvShowFrame();
            }
            case 65: {
                return new IDvSetLEC(data);
            }
            case 66: {
                return new RIDvSetLEC(data);
            }
            case 67: {
                return new IDbGetLEC();
            }
            case 68: {
                return new RIDbGetLEC(data);
            }
            case 49: {
                return new IDvSetEnableKey(data);
            }
            case 50: {
                return new RIDvSetEnableKey(data);
            }
            case 51: {
                return new IDbGetEnableKey();
            }
            case 52: {
                return new RIDbGetEnableKey(data);
            }
            case 119: {
                return new IDReloadPreImg();
            }
            case 120: {
                return new RIDReloadPreImg(data);
            }
            case 103: {
                return new IDvDeletePreImg();
            }
            case 104: {
                return new RIDvDeletePreImg(data);
            }
            case 209: {
                return new RIDvPlayAudio(data);
            }
            case 214: {
                return new IDQueryProcessFailure();
            }
            case 210: {
                return new IDSetAudioQuery(data);
            }
            case 211: {
                return new RIDSetAudioQuery(data);
            }
            case 212: {
                return new IDGetAudioQuery();
            }
            case 213: {
                return new RIDGetAudioQuery(data);
            }
        }
        return new TcUnknownCommand(id, data);
    }

    protected void onPartialFileReceive(String filepath, double progress, int filesize) {
    }

    protected void onFileReceived(RIDvRecvFile response) {
    }

    private class TcFileReceiver {
        private static final int ARG_FILENAME_SIZE = 128;
        private File currentOutputFile = null;
        private File folder = null;
        private String filename = null;
        private boolean fileNotFound = true;
        GenericTc terminal;

        private TcFileReceiver() {
        }

        private void reset() {
            this.currentOutputFile = null;
            this.filename = null;
        }

        public RIDvRecvFile checkFileComplete(int dataLength, DataBuffer dataBuffer) {
            if (this.filename == null) {
                if (dataBuffer.available() >= 128) {
                    this.filename = Util.getNullTerminatedString(dataBuffer.readBytes(128));
                    boolean bl = this.fileNotFound = dataBuffer.readInt() == 0;
                    if (this.fileNotFound) {
                        RIDvRecvFile response = new RIDvRecvFile(this.filename);
                        this.reset();
                        return response;
                    }
                } else {
                    return null;
                }
            }
            if (this.currentOutputFile == null) {
                FileUtilities fileUtils = FileUtilities.getInstance();
                if (this.folder != null && !this.folder.exists()) {
                    try {
                        this.folder = this.filename.endsWith(".conf") || this.filename.endsWith(".ini") ? fileUtils.getTemporaryConfigDir() : fileUtils.getTemporaryMediaDir();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.folder = null;
                        throw new RuntimeException(J18N.tr("Couldn't create temporary folder to receive files", new Object[0]));
                    }
                }
                if (this.folder == null) {
                    this.folder = this.filename.endsWith(".conf") || this.filename.endsWith(".ini") ? fileUtils.getTemporaryConfigDir() : fileUtils.getTemporaryMediaDir();
                }
                try {
                    this.currentOutputFile = new File(this.folder.getCanonicalPath() + "/" + Util.getFilenameFromCompletePath(this.filename));
                    if (this.currentOutputFile.exists() && !this.currentOutputFile.delete()) {
                        throw new RuntimeException("Cannot delete " + this.currentOutputFile.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            FileOutputStream fos = null;
            int fileSize = dataLength - 132;
            int remaining = (int)((long)fileSize - this.currentOutputFile.length());
            int bytesToRead = Math.min(dataBuffer.available(), remaining);
            try {
                fos = new FileOutputStream(this.currentOutputFile, true);
                fos.write(dataBuffer.readBytes(bytesToRead));
                fos.close();
                fos = null;
                double progress = (double)this.currentOutputFile.length() / (double)fileSize * 100.0;
                Sc504CommandBuilder.this.onPartialFileReceive(this.filename, progress, fileSize);
                if (bytesToRead == remaining) {
                    RIDvRecvFile response = new RIDvRecvFile(this.filename, this.currentOutputFile);
                    this.reset();
                    return response;
                }
                return null;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

