/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504;

import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504CommandBuilder;
import br.com.gertec.tc.server.protocol.sc504.Sc504TC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDRestart;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvLive;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSendFile;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvRecvFile;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.CommandBuilder;
import br.org.reconcavo.event.comm.DataBuffer;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Sc504Connection
extends AbstractTcConnection {
    private final List<FileReceiveListener> fileReceiveListeners = new LinkedList<FileReceiveListener>();
    private final List<Tc504Command.Tc504Request> requestQueue = new LinkedList<Tc504Command.Tc504Request>();
    private final Sc504CommandBuilder commandBuilder = new Sc504CommandBuilder(){

        @Override
        protected void onFileReceived(RIDvRecvFile response) {
            Sc504Connection.this.notifyFileReceived(response);
        }

        @Override
        protected void onPartialFileReceive(String filepath, double progress, int filesize) {
            Sc504Connection.this.notifyPartialFile(filepath, progress, filesize);
        }
    };
    private volatile boolean enqueueRequest = false;
    private volatile boolean throwOnResponse = true;
    private volatile boolean lenient = false;

    public Sc504Connection(EventLoop eventLoop) {
        super(eventLoop);
        this.setTerminal(new Sc504TC());
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    private void notifyFileReceived(RIDvRecvFile response) {
        this.onCommandRead(response);
        for (FileReceiveListener listener : this.fileReceiveListeners) {
            listener.onFileReceived(this, response);
        }
        for (FileReceiveListener fileReceiveListener : ListenerGroup.getInstance().getAllFileReceiveListeners()) {
            fileReceiveListener.onFileReceived(this, response);
        }
    }

    private void notifyPartialFile(String filepath, double progress, int filesize) {
        for (FileReceiveListener listener : this.fileReceiveListeners) {
            listener.onReceivingFile(this, filepath, progress, filesize);
        }
        for (FileReceiveListener fileReceiveListener : ListenerGroup.getInstance().getAllFileReceiveListeners()) {
            fileReceiveListener.onReceivingFile(this, filepath, progress, filesize);
        }
    }

    public void registerListener(FileReceiveListener listener) {
        if (!this.fileReceiveListeners.contains(listener)) {
            this.fileReceiveListeners.add(listener);
        }
    }

    public void unregisterListener(FileReceiveListener listener) {
        if (this.fileReceiveListeners.contains(listener)) {
            this.fileReceiveListeners.remove(listener);
        }
    }

    public void sendFile(IDvSendFile command, FileSendListener listener) {
        this.writeRequest(new IDvSendFileWrapper(command, listener));
    }

    private boolean requestShouldBeQueued() {
        return this.enqueueRequest;
    }

    public final void setRequestEnqueue(boolean enqueue) {
        if (!Objects.equals(this.enqueueRequest, enqueue)) {
            this.enqueueRequest = enqueue;
            if (!enqueue) {
                this.processRequestQueue();
            }
        }
    }

    public void writeRequest(Tc504Command.Tc504Request request) {
        if (!this.isLenient() && this.requestShouldBeQueued()) {
            this.requestQueue.add(request);
        } else {
            this.setRequestEnqueue(true);
            if (request instanceof IDvSendFileWrapper) {
                final IDvSendFileWrapper wrapper = (IDvSendFileWrapper)request;
                final boolean wasLenient = this.isLenient();
                final boolean liveTimerWasActive = this.isLiveTimerActive();
                if (liveTimerWasActive) {
                    this.enableLiveTimer(false);
                }
                if (wasLenient) {
                    this.setLenient(false);
                }
                Thread t = new Thread(new Runnable(){
                    private static final int CHUNK_SIZE = 4096;
                    private FileInputStream fis;
                    private byte[] buffer;
                    private long remainingBytes;

                    private void notifyListenerAboutSendProgress(final FileSendListener listener, final String destPath, final File srcFile, final double progress, final int fileSize) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onSendProgress(Sc504Connection.this, destPath, srcFile, progress, fileSize);
                                }
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            runnable.run();
                        } else {
                            EventQueue.invokeLater(runnable);
                        }
                    }

                    private void notifyListenerAboutSendComplete(final FileSendListener listener, final String destPath, final File srcFile) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onSendComplete(Sc504Connection.this, destPath, srcFile);
                                }
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            runnable.run();
                        } else {
                            EventQueue.invokeLater(runnable);
                        }
                    }

                    private void notifyListenerAboutSendError(final FileSendListener listener, final String destPath, final File srcFile, final Throwable error) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onError(Sc504Connection.this, destPath, srcFile, error);
                                }
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            runnable.run();
                        } else {
                            EventQueue.invokeLater(runnable);
                        }
                    }

                    private byte[] read() throws IOException {
                        if (this.remainingBytes > 4096L) {
                            this.buffer = new byte[4096];
                            this.remainingBytes -= 4096L;
                        } else {
                            this.buffer = new byte[(int)this.remainingBytes];
                            this.remainingBytes = 0L;
                        }
                        if (this.fis.read(this.buffer) == -1) {
                            throw new IOException("EOF reached while trying to read the whole file");
                        }
                        return this.buffer;
                    }

                    @Override
                    public void run() {
                        FileSendListener listener;
                        String destPath;
                        File srcFile;
                        block24: {
                            srcFile = wrapper.getCmd().getFile();
                            destPath = wrapper.getCmd().getDestPath();
                            int fileSize = (int)srcFile.length();
                            this.remainingBytes = fileSize;
                            if (!srcFile.exists()) {
                                throw new RuntimeException("File " + srcFile.getName() + " doesn't exists");
                            }
                            DataBuffer dataBuffer = new DataBuffer();
                            dataBuffer.put(wrapper.getCmd().getHeader());
                            if (destPath.getBytes().length < 128) {
                                dataBuffer.putString(destPath, 128);
                            } else {
                                if (destPath.getBytes().length > 128) {
                                    throw new RuntimeException(String.format("Error: filename length > %d bytes", 128));
                                }
                                dataBuffer.putString(destPath);
                            }
                            Sc504Connection.this.setRequestEnqueue(true);
                            listener = wrapper.getListener();
                            try (FileInputStream fis = new FileInputStream(srcFile);){
                                this.fis = fis;
                                Sc504Connection.this.write(dataBuffer.readBytes());
                                if (listener != null) {
                                    this.notifyListenerAboutSendProgress(listener, destPath, srcFile, 0.0, fileSize);
                                }
                                while (this.remainingBytes != 0L) {
                                    byte[] tempBuffer = this.read();
                                    if (!Sc504Connection.this.write(tempBuffer)) {
                                        break;
                                    }
                                    double progress = (double)((long)fileSize - this.remainingBytes) / (double)fileSize;
                                    if (listener == null) continue;
                                    this.notifyListenerAboutSendProgress(listener, destPath, srcFile, progress, fileSize);
                                }
                            }
                            catch (IOException ex) {
                                if (listener == null) break block24;
                                this.notifyListenerAboutSendError(listener, destPath, srcFile, ex);
                            }
                        }
                        if (liveTimerWasActive) {
                            Sc504Connection.this.enableLiveTimer(true);
                        }
                        if (wasLenient) {
                            Sc504Connection.this.setLenient(true);
                        }
                        if (listener != null) {
                            this.notifyListenerAboutSendComplete(listener, destPath, srcFile);
                        }
                    }
                });
                t.start();
            } else {
                super.writeCommand((Command)((Object)request));
            }
        }
    }

    private boolean throwOnResponse() {
        return this.throwOnResponse;
    }

    public final void setThrowOnResponse(boolean throwOnResponse) {
        this.throwOnResponse = throwOnResponse;
    }

    public void writeResponse(Tc504Command.Tc504Response response) throws IllegalStateException {
        if (!this.isLenient() && this.throwOnResponse()) {
            throw new IllegalStateException("Cannot send a response without a previously sent request");
        }
        super.writeCommand((Command)((Object)response));
        this.setThrowOnResponse(true);
    }

    private void processRequestQueue() {
        while (!this.requestQueue.isEmpty()) {
            if (this.requestShouldBeQueued()) {
                return;
            }
            Tc504Command.Tc504Request request = this.requestQueue.remove(0);
            this.writeRequest(request);
        }
    }

    @Override
    protected void onCommandRead(Command command) {
        if (this.getTerminalType() == TerminalType.TC_504) {
            this.commandBuilder.setTerminalType(this.getTerminalType());
        }
        if (command instanceof Tc504Command) {
            Tc504Command tcCommand = (Tc504Command)command;
            if (tcCommand instanceof Tc504Command.Tc504Response) {
                super.onCommandRead(command);
                if (!this.isLenient()) {
                    Runnable allowRequestSendRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Sc504Connection.this.setRequestEnqueue(false);
                        }
                    };
                    this.getEventLoop().invokeLater(allowRequestSendRunnable);
                }
            } else {
                this.setThrowOnResponse(false);
                super.onCommandRead(command);
            }
        } else {
            super.onCommandRead(command);
        }
    }

    @Override
    public final boolean writeCommand(Command command) {
        if (!(command instanceof Tc504Command)) {
            throw new IllegalArgumentException("Unsupported command type: " + command.getClass().getName());
        }
        Tc504Command tcCommand = (Tc504Command)command;
        if (tcCommand instanceof Tc504Command.Tc504Response) {
            this.writeResponse((Tc504Command.Tc504Response)((Object)tcCommand));
        } else if (tcCommand instanceof Tc504Command.Tc504Request) {
            this.writeRequest((Tc504Command.Tc504Request)((Object)tcCommand));
        } else {
            throw new IllegalArgumentException("Unsupported command type: " + command.getClass().getName());
        }
        return true;
    }

    @Override
    protected CommandBuilder getCommandBuilder() {
        return this.commandBuilder;
    }

    @Override
    protected void checkLive() {
        this.writeCommand(new IDvLive());
    }

    @Override
    public void sendRestartTerminal() {
        IDRestart command = new IDRestart();
        this.writeCommand(command);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.enqueueRequest = false;
        this.throwOnResponse = true;
    }

    private static class IDvSendFileWrapper
    implements Tc504Command.Tc504Request {
        private final IDvSendFile cmd;
        private final FileSendListener listener;

        public IDvSendFileWrapper(IDvSendFile cmd, FileSendListener listener) {
            this.cmd = cmd;
            this.listener = listener;
        }

        public IDvSendFile getCmd() {
            return this.cmd;
        }

        public FileSendListener getListener() {
            return this.listener;
        }
    }

    public static interface FileSendListener {
        public void onSendProgress(Sc504Connection var1, String var2, File var3, double var4, int var6);

        public void onSendComplete(Sc504Connection var1, String var2, File var3);

        public void onError(Sc504Connection var1, String var2, File var3, Throwable var4);

        public static class FileSendAdapter
        implements FileSendListener {
            @Override
            public void onSendProgress(Sc504Connection connection, String destPath, File srcFile, double progress, int filesize) {
            }

            @Override
            public void onSendComplete(Sc504Connection connection, String destPath, File srcFile) {
            }

            @Override
            public void onError(Sc504Connection connection, String destPath, File srcFile, Throwable t) {
            }
        }
    }

    public static interface FileReceiveListener {
        public void onFileReceived(Sc504Connection var1, RIDvRecvFile var2);

        public void onReceivingFile(Sc504Connection var1, String var2, double var3, int var5);

        public static class FileReceiveAdapter
        implements FileReceiveListener {
            @Override
            public void onFileReceived(Sc504Connection connection, RIDvRecvFile receivedFile) {
            }

            @Override
            public void onReceivingFile(Sc504Connection connection, String filepath, double progress, int filesize) {
            }
        }
    }
}

