/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504TC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDContinue;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetMACAddress;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetVersion;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetUID;
import br.com.gertec.tc.server.protocol.sc504.commands.IDwGetIdentify;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDContinue;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetMACAddress;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetVersion;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDRestart;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDSetAudioQuery;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupTCP;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetSetupWiFi;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetTimeExhib;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvGetUID;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvLive;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvPlayAudio;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDwGetIdentify;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.protocol.sc504.listener.Sc504ServerListener;
import br.com.gertec.tc.server.protocol.sc504.params.ArgSetupTcp;
import br.com.gertec.tc.server.protocol.sc504.params.ArgSetupWiFi;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.version.DeviceVersion;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Listener;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;
import java.util.List;

public class Sc504Server
extends TcpServer {
    public static final Event EVT_COMMAND_READ = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc504ServerListener) {
                ((Sc504ServerListener)listener).onCommandReceived((Sc504Server)args[0], (Sc504Connection)args[1], (Tc504Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            ((Sc504Server)args[0]).onCommandReceived((Sc504Connection)args[1], (Tc504Command)args[2]);
        }
    };
    public static final Event EVT_COMMAND_WRITE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc504ServerListener) {
                ((Sc504ServerListener)listener).onCommandWrite((Sc504Server)args[0], (Sc504Connection)args[1], (Tc504Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            ((Sc504Server)args[0]).onCommandWrite((Sc504Connection)args[1], (Tc504Command)args[2]);
        }
    };
    public static final Event EVT_HANDSHAKE_COMPLETE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc504ServerListener) {
                ((Sc504ServerListener)listener).onHandshakeComplete((Sc504Server)args[0], (Sc504Connection)args[1]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            ((Sc504Server)args[0]).onHandshakeComplete((Sc504Connection)args[1]);
        }
    };

    public Sc504Server(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected SocketConnection getClientConnection(EventLoop serverEventLoop) {
        return new Sc504Connection(serverEventLoop){
            private boolean handshakeComplete;
            {
                this.handshakeComplete = false;
            }

            @Override
            protected void onClose() {
                super.onClose();
                this.handshakeComplete = false;
            }

            @Override
            protected void onOpen() {
                super.onOpen();
                this.writeCommand(new IDwGetIdentify());
            }

            @Override
            protected void onCommandRead(Command command) {
                super.onCommandRead(command);
                Sc504Server.this.notifyEvent(EVT_COMMAND_READ, Sc504Server.this, this, (Tc504Command)command);
                Log.debug(J18N.tr("Received command from %s: %s", this.getInetAddress().getHostAddress(), command, command.toString()), new Object[0]);
                Tc504Command tcCommand = (Tc504Command)command;
                switch (tcCommand.getId()) {
                    case 20: {
                        this.onRIDwGetIdentify((RIDwGetIdentify)tcCommand);
                        break;
                    }
                    case 22: {
                        this.onRIDContinue((RIDContinue)tcCommand);
                        break;
                    }
                    case 18: {
                        this.onRIDvLive((RIDvLive)tcCommand);
                        break;
                    }
                    case 217: {
                        this.onRIDGetVersion((RIDGetVersion)tcCommand);
                        break;
                    }
                    case 28: {
                        this.onRIDwGetUID((RIDvGetUID)tcCommand);
                        break;
                    }
                    case 26: {
                        this.onRIDvGetSetupTcp((RIDvGetSetupTCP)tcCommand);
                        break;
                    }
                    case 154: {
                        if (this.getTerminalType() == TerminalType.TC_504) break;
                        this.onRIDvGetSetupWifi((RIDvGetSetupWiFi)tcCommand);
                        break;
                    }
                    case 219: {
                        this.onRIDGetMACAddress((RIDGetMACAddress)tcCommand);
                        break;
                    }
                    case 171: {
                        this.onRIDGetSensorStatus((RIDGetSensorStatus)tcCommand);
                        break;
                    }
                    case 175: {
                        this.onRIDGetAudioStatus((RIDGetAudioStatus)tcCommand);
                        break;
                    }
                    case 179: {
                        this.onRIDGetVolume((RIDGetVolume)tcCommand);
                        break;
                    }
                    case 183: {
                        this.onRIDGetBrightness((RIDGetBrightness)tcCommand);
                        break;
                    }
                    case 42: {
                        this.onRIDvGetTimeExhib((RIDvGetTimeExhib)tcCommand);
                        break;
                    }
                    case 122: {
                        this.onRIDRestart((RIDRestart)tcCommand);
                        break;
                    }
                    case 52: {
                        this.onRIDbGetEnableKey((RIDbGetEnableKey)tcCommand);
                        break;
                    }
                    case 68: {
                        this.onRIDbGetLEC((RIDbGetLEC)tcCommand);
                        break;
                    }
                    case 209: {
                        this.onRIDvPlayAudio((RIDvPlayAudio)tcCommand);
                        break;
                    }
                    case 214: {
                        this.onIDQueryProcessFailure();
                    }
                    case 211: {
                        this.onRIDSetAudioQuery((RIDSetAudioQuery)tcCommand);
                        break;
                    }
                    case 213: {
                        this.onRIDGetAudioQuery((RIDGetAudioQuery)tcCommand);
                    }
                }
                List<CommandListener> cmdListeners = ListenerGroup.getInstance().getAllCommandListeners(tcCommand);
                for (CommandListener cmdListener : cmdListeners) {
                    cmdListener.onCommandRead(this, command);
                }
            }

            private void onRIDGetMACAddress(RIDGetMACAddress cmd) {
                GenericTc terminal = this.getTerminal();
                terminal.setMacAddress(cmd.getMacEth());
                terminal.setMacWifi(cmd.getMacWifi());
            }

            @Override
            protected void onCommandWrite(Command command) {
                super.onCommandWrite(command);
                Sc504Server.this.notifyEvent(EVT_COMMAND_WRITE, Sc504Server.this, this, (Tc504Command)command);
                Log.debug(J18N.tr("Command sent to %s: %s", this.getInetAddress().getHostAddress(), command), new Object[0]);
            }

            private void onRIDwGetUID(RIDvGetUID cmd) {
                GenericTc terminal = this.getTerminal();
                terminal.setMacAddress(Util.getStringFromMacBytes(cmd.getMacAddress()));
                terminal.setTcName(cmd.getTerminalName());
                if (DeviceVersion.isNewVersion(terminal.getType(), terminal.getTerminalVersion())) {
                    this.writeCommand(new IDGetMACAddress());
                    this.writeCommand(new IDGetAudioQuery());
                    this.writeCommand(new IDGetVersion());
                } else if (!this.handshakeComplete) {
                    this.handshakeComplete = true;
                    Sc504Server.this.notifyEvent(EVT_HANDSHAKE_COMPLETE, Sc504Server.this, this);
                    this.onHandshakeCompleted();
                }
            }

            private void onRIDwGetIdentify(RIDwGetIdentify cmd) {
                GenericTc terminal = this.getTerminal();
                terminal.setType(TerminalType.fomSc504Id(cmd.getTermType()));
                terminal.setTerminalVersion(String.valueOf(cmd.getTermVersion()));
                terminal.setInetAddress(this.getInetAddress());
                if (VersionsWithAudio.iTC506Audio(terminal.getTerminalVersion())) {
                    terminal.isTcWithAudio(true);
                } else {
                    terminal.isTcWithAudio(false);
                }
                boolean accepted = terminal.getType() != null;
                IDContinue response = new IDContinue(accepted);
                this.writeCommand(response);
                if (!accepted) {
                    this.close();
                }
            }

            private void onRIDGetVersion(RIDGetVersion cmd) {
                GenericTc terminal = this.getTerminal();
                terminal.setFirmwareVersion(cmd.getFirmwareVersion());
                if (!this.handshakeComplete) {
                    this.handshakeComplete = true;
                    Sc504Server.this.notifyEvent(EVT_HANDSHAKE_COMPLETE, Sc504Server.this, this);
                    this.onHandshakeCompleted();
                }
            }

            private void onRIDRestart(RIDRestart cmd) {
                if (cmd.isSuccess()) {
                    Log.debug(J18N.tr("Closing connection with %s due to restart", this.getInetAddress()), new Object[0]);
                    this.close();
                } else {
                    Log.debug(J18N.tr("Couldn't restart %s", this.getInetAddress()), new Object[0]);
                }
            }

            private void onRIDvLive(RIDvLive cmd) {
            }

            private void onRIDContinue(RIDContinue cmd) {
                this.writeCommand(new IDvGetUID());
            }

            private void onRIDvGetSetupTcp(RIDvGetSetupTCP cmd) {
                GenericTc terminal = this.getTerminal();
                ArgSetupTcp terminalSetup = cmd.getArgSetupTcp();
                terminal.setTcName(terminalSetup.getTerminalName());
                terminal.setDns(Util.getIpV4String(terminalSetup.getNameServer()));
                terminal.setGateway(Util.getIpV4String(terminalSetup.getGateway()));
                terminal.setNetmask(Util.getIpV4String(terminalSetup.getNetmask()));
                terminal.setUsesDhcp(terminalSetup.isDhcpEnabled());
                ((Sc504TC)terminal).setServerSearchOn(terminalSetup.isServerSearchEnabled());
            }

            private void onRIDvGetSetupWifi(RIDvGetSetupWiFi cmd) {
                ArgSetupWiFi terminalSetup = cmd.getArgSetupWiFi();
                ((Sc504TC)this.getTerminal()).setWifiSetup(terminalSetup);
            }

            private void onRIDGetSensorStatus(RIDGetSensorStatus cmd) {
                ((Sc504TC)this.getTerminal()).setSensorOn(cmd.isEnabled());
            }

            private void onRIDGetAudioStatus(RIDGetAudioStatus cmd) {
                ((Sc504TC)this.getTerminal()).setVolumeOn(cmd.isEnabled());
            }

            private void onRIDGetVolume(RIDGetVolume cmd) {
                ((Sc504TC)this.getTerminal()).setVolume(cmd.getVolume());
            }

            private void onRIDGetBrightness(RIDGetBrightness cmd) {
                ((Sc504TC)this.getTerminal()).setBrightness(cmd.getBrightness());
            }

            private void onRIDvGetTimeExhib(RIDvGetTimeExhib cmd) {
                ((Sc504TC)this.getTerminal()).setTimeExhib(cmd.getExhibitionTime());
            }

            private void onRIDbGetEnableKey(RIDbGetEnableKey cmd) {
                ((Sc504TC)this.getTerminal()).setKeyboardOn(cmd.isEnabled());
            }

            private void onRIDbGetLEC(RIDbGetLEC cmd) {
                ((Sc504TC)this.getTerminal()).setCardOn(cmd.isEnabled());
            }

            private void onRIDvPlayAudio(RIDvPlayAudio cmd) {
                boolean success = cmd.isSuccess();
                if (success) {
                    Log.info(J18N.tr("Audio played successfully on %s%s", this.getTerminal().getTcName(), this.getInetAddress()), new Object[0]);
                } else {
                    Log.warning(J18N.tr("Error playing audio on %s%s", this.getTerminal().getTcName(), this.getInetAddress()), new Object[0]);
                }
            }

            private void onIDQueryProcessFailure() {
                Log.info(J18N.tr("RIDQueryProcessFailure command received: failure in processing price query in remote device (%s%s)", this.getTerminal().getTcName(), this.getInetAddress()), new Object[0]);
            }

            private void onRIDSetAudioQuery(RIDSetAudioQuery cmd) {
                if (!cmd.isSuccess()) {
                    Log.info(J18N.tr("Unable to change the query audio status on %s%s", this.getTerminal().getTcName(), this.getInetAddress()), new Object[0]);
                }
            }

            private void onRIDGetAudioQuery(RIDGetAudioQuery cmd) {
                ((Sc504TC)this.getTerminal()).setAudioStatus(cmd.isSuccess());
            }
        };
    }

    @Override
    protected void onNewClient(SocketConnection client) {
        super.onNewClient(client);
        Log.debug(J18N.tr("New client: %s", client.getInetAddress().getHostAddress()), new Object[0]);
    }

    @Override
    protected void onClientDrop(SocketConnection client) {
        super.onClientDrop(client);
        Log.debug(J18N.tr("Client disconnected: %s", client.getInetAddress().getHostAddress()), new Object[0]);
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.debug(J18N.tr("SC504 server is running on port %d", this.getLocalPort()), new Object[0]);
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.debug(J18N.tr("SC504 server stopped", new Object[0]), new Object[0]);
    }

    protected void onCommandReceived(Sc504Connection connection, Tc504Command command) {
    }

    protected void onCommandWrite(Sc504Connection connection, Tc504Command command) {
    }

    protected void onHandshakeComplete(Sc504Connection connection) {
    }
}

