/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.Serializable;

public class IDbReadScanner
extends Tc504Command
implements Tc504Command.Tc504Request {
    private static final long serialVersionUID = 1L;
    private static final int CODE_MAX_LENGTH = 256;
    private final ArgSerialData argSerialData;

    public IDbReadScanner(String code) {
        this(new ArgSerialData(code).getSerializedData());
    }

    public IDbReadScanner(byte[] data) {
        super((short)89, data);
        this.argSerialData = new ArgSerialData(data);
    }

    protected ArgSerialData getArgSerialData() {
        return this.argSerialData;
    }

    public String getCode() {
        return this.getArgSerialData().code;
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.getArgSerialData().toString());
    }

    protected static class ArgSerialData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final short codeLen;
        public final String code;

        public ArgSerialData(byte[] data) {
            DataBuffer buffer = new DataBuffer();
            buffer.put(data);
            this.codeLen = buffer.readShort();
            this.code = new String(buffer.readBytes(this.codeLen));
        }

        public ArgSerialData(String code) {
            if (code.length() > 256) {
                throw new IllegalArgumentException("Code is too long");
            }
            this.code = code;
            this.codeLen = (short)code.length();
        }

        public String toString() {
            return String.format("codeLen: %d, code: %s", this.codeLen, this.code);
        }

        public byte[] getSerializedData() {
            DataBuffer buffer = new DataBuffer();
            buffer.putShort(this.codeLen);
            buffer.putString(this.code, 256);
            return buffer.readBytes();
        }
    }
}

