/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.customer.audio.online.google.GenerateAudio;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.commands.Sc504CommDefs;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.PassParameter;
import br.com.gertec.tc.server.util.VolumeConfig;
import br.org.reconcavo.event.comm.ByteOrder;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import javax.sound.sampled.UnsupportedAudioFileException;

public class IDvPlayAudio
extends Tc504Command
implements Tc504Command.Tc504Request {
    private static final long serialVersionUID = 1L;
    public static final int ARG_FILENAME_SIZE = 128;
    public static final int ARG_SIZE = 129;
    private static final String NOT_FOUND = "nfound";
    private File file;
    private String destPath;
    private TerminalType terminal = null;

    public IDvPlayAudio(TerminalType terminal, File file) {
        super((short)208);
        this.file = this.verifyAudioFile(file);
        this.destPath = file.getAbsolutePath();
        this.terminal = terminal;
    }

    private File verifyAudioFile(File audio) {
        boolean needNewAudio = false;
        String msgInfo = " An audio with the description \"Audio description unavailable\" will be sent.";
        if (audio == null) {
            Log.warning(J18N.tr("Audio file is null.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (!audio.exists()) {
            Log.warning(J18N.tr("Audio not found.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (audio.getPath().getBytes().length > 128) {
            Log.warning(J18N.tr("Audio is too big." + J18N.tr(msgInfo, new Object[0]), new Object[0]), new Object[0]);
            needNewAudio = true;
        }
        if (PassParameter.isInvalidAmount()) {
            Log.warning(J18N.tr("Invalid number of characters.", new Object[0]) + J18N.tr(msgInfo, new Object[0]), new Object[0]);
        }
        if (needNewAudio) {
            File newAudio = null;
            try {
                JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioNotFound(GenerateAudioImpl.fileUnavailable, NOT_FOUND);
                if (!returnValue.isFromICTS()) {
                    Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                }
                newAudio = returnValue.getAudioFinalFile();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            return newAudio;
        }
        return audio;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getDestPath() {
        return this.destPath;
    }

    @Override
    public byte[] getSerializedData() {
        String fileName = this.getFile().getName();
        DataBuffer dbf = new DataBuffer();
        dbf.put((byte)2);
        dbf.putShort((short)208, Sc504CommDefs.DEFAULT_BYTE_ORDER);
        dbf.putInt((int)this.getFile().length() + 129, ByteOrder.LITTLE_ENDIAN);
        if (this.terminal == TerminalType.TC_506_MIDIA) {
            dbf.put((byte)VolumeConfig.getAudioTc506m());
        } else if (this.terminal == TerminalType.GB_600) {
            dbf.put((byte)VolumeConfig.getAudioGBot());
        } else if (this.terminal == TerminalType.GB_601) {
            dbf.put((byte)VolumeConfig.getAudioGBot());
        } else {
            dbf.put((byte)100);
        }
        dbf.putString(fileName);
        dbf.putZeros(fileName.length(), 128);
        dbf.put(GenerateAudio.getBytes(this.file));
        return dbf.readBytes();
    }

    public byte[] getHeader() {
        int dataLength = 128 + (int)this.file.length();
        DataBuffer dbf = new DataBuffer();
        dbf.put((byte)2);
        dbf.putShort((short)208, Sc504CommDefs.DEFAULT_BYTE_ORDER);
        dbf.putInt(dataLength, Sc504CommDefs.DEFAULT_BYTE_ORDER);
        return dbf.readBytes();
    }
}

