/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.protocol.sc504.commands.Sc504CommDefs;
import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.File;

public class IDvSendFile
extends Tc504Command
implements Tc504Command.Tc504Request {
    private static final long serialVersionUID = 1L;
    public static final int ARG_FILENAME_SIZE = 128;
    private File file;
    private String destPath;

    public IDvSendFile(String destPath, File file) {
        super((short)99);
        this.destPath = destPath;
        this.file = file;
        if (!file.exists()) {
            throw new RuntimeException("file " + file.getName() + " doesn't exists");
        }
        if (destPath.getBytes().length > 128) {
            throw new RuntimeException("Error: destination path length > 128 bytes");
        }
    }

    public final File getFile() {
        return this.file;
    }

    public final String getDestPath() {
        return this.destPath;
    }

    public byte[] getHeader() {
        int dataLength = 128 + (int)this.file.length();
        DataBuffer dbf = new DataBuffer();
        dbf.put((byte)2);
        dbf.putShort((short)99, Sc504CommDefs.DEFAULT_BYTE_ORDER);
        dbf.putInt(dataLength, Sc504CommDefs.DEFAULT_BYTE_ORDER);
        return dbf.readBytes();
    }

    @Override
    public byte[] getSerializedData() {
        throw new UnsupportedOperationException("Use connections sendFile method");
    }
}

