/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.commands;

import br.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import java.io.File;
import java.io.IOException;

public class RIDvRecvFile
extends Tc504Command
implements Tc504Command.Tc504Response {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final File receivedFile;

    public RIDvRecvFile(String filename, File receivedFile) {
        super((short)98);
        System.out.println("Main File :" + filename);
        System.out.println("Local memory :" + receivedFile);
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty filename");
        }
        if (receivedFile != null) {
            try {
                if (!receivedFile.exists()) {
                    throw new IllegalArgumentException("receivedFile does not exist: " + receivedFile.getCanonicalPath());
                }
                if (receivedFile.isDirectory()) {
                    throw new IllegalArgumentException("receivedFile points to a directory: " + receivedFile.getCanonicalPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.filename = filename;
        this.receivedFile = receivedFile;
    }

    public RIDvRecvFile(String filename) {
        this(filename, null);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isFound() {
        return this.receivedFile != null;
    }

    public File getReceivedFile() {
        return this.receivedFile;
    }

    @Override
    public byte[] getSerializedData() {
        throw new UnsupportedOperationException("This command should not be send explicitly");
    }

    @Override
    public String toString() {
        return String.format("%s (file: %s, found: %s)", this.getClass().getSimpleName(), this.getFilename(), this.isFound());
    }
}

