/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.params;

import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.Serializable;

public class ArgSetupTcp
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TERMINAL_NAME_MAX_LENGTH = 32;
    private static final int FTP_SERVER_MAX_LENGTH = 100;
    private static final int FTP_USER_MAX_LENGTH = 30;
    private static final int FTP_PASSWORD_MAX_LENGTH = 30;
    private final byte[] terminalIp;
    private final byte[] serverIp;
    private final byte[] netmask;
    private final byte[] gateway;
    private final byte[] nameServer;
    private final int dhcpEnabled;
    private final int serverSearchEnabled;
    private final short serverPort;
    private final String terminalName;
    private final String ftpServer;
    private final String ftpUser;
    private final String ftpPassword;

    public ArgSetupTcp(byte[] data) {
        DataBuffer buffer = new DataBuffer();
        buffer.put(data);
        this.terminalIp = buffer.readBytes(4);
        this.serverIp = buffer.readBytes(4);
        this.netmask = buffer.readBytes(4);
        this.gateway = buffer.readBytes(4);
        this.nameServer = buffer.readBytes(4);
        this.terminalName = Util.getCString(buffer.readString(32));
        this.serverPort = buffer.readShort();
        this.ftpServer = Util.getCString(buffer.readString(100));
        this.ftpUser = Util.getCString(buffer.readString(30));
        this.ftpPassword = Util.getCString(buffer.readString(30));
        this.dhcpEnabled = buffer.readInt();
        this.serverSearchEnabled = buffer.readInt();
    }

    public ArgSetupTcp(byte[] terminalIp, byte[] serverIp, byte[] netmask, byte[] gateway, byte[] nameServer, int dhcpEnabled, int serverSearchEnabled, short serverPort, String terminalName, String ftpServer, String ftpUser, String ftpPassword) {
        if (terminalIp.length != 4) {
            throw new IllegalArgumentException("Invalid Terminal IP address: " + Util.getIpV4String(terminalIp));
        }
        if (serverIp.length != 4) {
            throw new IllegalArgumentException("Invalid Server IP address: " + Util.getIpV4String(serverIp));
        }
        if (netmask.length != 4) {
            throw new IllegalArgumentException("Invalid netmask: " + Util.getIpV4String(netmask));
        }
        if (gateway.length != 4) {
            throw new IllegalArgumentException("Invalid gateway address: " + Util.getIpV4String(gateway));
        }
        if (nameServer.length != 4) {
            throw new IllegalArgumentException("Invalid DNS address: " + Util.getIpV4String(nameServer));
        }
        if (terminalName.getBytes().length > 32) {
            throw new IllegalArgumentException("Terminal name is too long: " + terminalName);
        }
        if (ftpServer.getBytes().length > 100) {
            throw new IllegalArgumentException("FTP Server parameter is too long: " + ftpServer);
        }
        if (ftpUser.getBytes().length > 30) {
            throw new IllegalArgumentException("FTP user is too long: " + ftpUser);
        }
        if (ftpPassword.getBytes().length > 30) {
            throw new IllegalArgumentException("FTP password is too long: " + ftpPassword);
        }
        this.terminalIp = terminalIp;
        this.serverIp = serverIp;
        this.netmask = netmask;
        this.gateway = gateway;
        this.nameServer = nameServer;
        this.dhcpEnabled = dhcpEnabled;
        this.serverSearchEnabled = serverSearchEnabled;
        this.serverPort = serverPort;
        this.terminalName = terminalName;
        this.ftpServer = ftpServer;
        this.ftpUser = ftpUser;
        this.ftpPassword = ftpPassword;
    }

    public byte[] getTerminalIp() {
        return this.terminalIp;
    }

    public byte[] getServerIp() {
        return this.serverIp;
    }

    public byte[] getNetmask() {
        return this.netmask;
    }

    public byte[] getGateway() {
        return this.gateway;
    }

    public byte[] getNameServer() {
        return this.nameServer;
    }

    public short getServerPort() {
        return this.serverPort;
    }

    public String getTerminalName() {
        return this.terminalName;
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public boolean isDhcpEnabled() {
        return this.dhcpEnabled == 1;
    }

    public boolean isServerSearchEnabled() {
        return this.serverSearchEnabled == 1;
    }

    public String toString() {
        return String.format("\n terminalIp: %s;\n serverIp: %s;\n netmask %s;\n gateway: %s;\n name server(DNS): %s;\n DHCP: %s;\n server search: %s;\n server port: %s;\n terminal name: %s;", Util.getIpV4String(this.terminalIp), Util.getIpV4String(this.serverIp), Util.getIpV4String(this.netmask), Util.getIpV4String(this.gateway), Util.getIpV4String(this.nameServer), this.isDhcpEnabled(), this.isServerSearchEnabled(), this.serverPort, this.getTerminalName());
    }

    public byte[] getSerializedData() {
        DataBuffer buffer = new DataBuffer();
        buffer.put(this.terminalIp[0]);
        buffer.put(this.terminalIp[1]);
        buffer.put(this.terminalIp[2]);
        buffer.put(this.terminalIp[3]);
        buffer.put(this.serverIp[0]);
        buffer.put(this.serverIp[1]);
        buffer.put(this.serverIp[2]);
        buffer.put(this.serverIp[3]);
        buffer.put(this.netmask[0]);
        buffer.put(this.netmask[1]);
        buffer.put(this.netmask[2]);
        buffer.put(this.netmask[3]);
        buffer.put(this.gateway[0]);
        buffer.put(this.gateway[1]);
        buffer.put(this.gateway[2]);
        buffer.put(this.gateway[3]);
        buffer.put(this.nameServer[0]);
        buffer.put(this.nameServer[1]);
        buffer.put(this.nameServer[2]);
        buffer.put(this.nameServer[3]);
        buffer.putString(this.terminalName, 32);
        buffer.putShort(this.serverPort);
        buffer.putString(this.ftpServer, 100);
        buffer.putString(this.ftpUser, 30);
        buffer.putString(this.ftpPassword, 30);
        buffer.putInt(this.dhcpEnabled);
        buffer.putInt(this.serverSearchEnabled);
        return buffer.readBytes();
    }
}

