/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc504.params;

import br.com.gertec.tc.server.protocol.WiFiSecurity;
import br.com.gertec.tc.server.protocol.WifiMode;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.Serializable;

public class ArgSetupWiFi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SSID_MAX_LENGTH = 20;
    private static final int NETWORK_KEY_MAX_LENGTH = 64;
    private final boolean wifiEnabled;
    private final WifiMode mode;
    private final String ssid;
    private final int channel;
    private final WiFiSecurity security;
    private final String key;

    public ArgSetupWiFi(byte[] data) {
        DataBuffer buffer = new DataBuffer();
        buffer.put(data);
        this.wifiEnabled = buffer.readInt() == 1;
        this.mode = WifiMode.fromSc504Val(buffer.readInt());
        this.ssid = buffer.readString(20);
        this.channel = buffer.readInt();
        this.security = WiFiSecurity.fromSc504Val(buffer.readInt());
        this.key = buffer.readString(64);
    }

    public ArgSetupWiFi(boolean wifiEnabled, WifiMode mode, String ssid, int channel, WiFiSecurity security, String key) {
        if (ssid.getBytes().length > 20) {
            throw new IllegalArgumentException("SSID is too long: " + ssid);
        }
        if (key.getBytes().length > 64) {
            throw new IllegalArgumentException("network key is too long: " + key);
        }
        this.wifiEnabled = wifiEnabled;
        this.mode = mode;
        this.ssid = ssid;
        this.channel = channel;
        this.security = security;
        this.key = key;
    }

    public byte[] getSerializedData() {
        DataBuffer buffer = new DataBuffer();
        buffer.putInt(this.wifiEnabled ? 1 : 0);
        buffer.putInt(this.mode.getSc504Value());
        buffer.putString(this.ssid, 20);
        buffer.putInt(this.channel);
        buffer.putInt(this.security.getSc504Value());
        buffer.putString(this.key, 64);
        return buffer.readBytes();
    }

    public boolean isWifiEnabled() {
        return this.wifiEnabled;
    }

    public WifiMode getMode() {
        return this.mode;
    }

    public String getSsid() {
        return this.ssid.split(String.valueOf('\u0000'))[0];
    }

    public int getChannel() {
        return this.channel;
    }

    public WiFiSecurity getSecurity() {
        return this.security;
    }

    public String getKey() {
        return this.key.split(String.valueOf('\u0000'))[0];
    }

    public String toString() {
        return String.format("enabled: %s, mode: %s, SSID: %s, channel: %d, security: %s, key: %s", this.wifiEnabled, this.mode.name(), this.getSsid(), this.channel, this.security.name(), this.getKey());
    }
}

