/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvDispClear;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowImg;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvShowText;
import br.com.gertec.tc.server.query.Sc504QueryExecutor;
import br.com.gertec.tc.server.util.CommandToImage;
import br.com.gertec.tc.server.util.Util;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.util.LinkedList;
import java.util.List;
import org.h2.message.DbException;

public class GerBotTwoQueryExecutor
extends Sc504QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc504Query(connection, barcode);
    }

    private void doSc504Query(AbstractTcConnection connection, String barcode) {
        Product product = this.getProductByBarcode(barcode);
        if (product == null) {
            connection.writeCommand(new IDvShowText("Produto n\u00e3o encontrado"));
        } else {
            product = this.verifyProduct(product);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
            Exhibition exhibition = ProductExhibition.get(barcode, connection.getTerminalType());
            exhibition = Exhibition.combine(defaultExhibition, exhibition);
            if (exhibition.getMediaType() == Exhibition.MediaType.SERVER_IMAGE) {
                List<Command> cmdList = this.createCommandList(exhibition, product);
                connection.writeCommand(new IDvShowImg(Util.getIndexedImageStream(CommandToImage.fromText(cmdList), connection.getTerminalType().getDisplayWidth(), connection.getTerminalType().getDisplayHeight())));
            } else if (exhibition.getMediaType() == Exhibition.MediaType.TERMINAL_IMAGE) {
                String queryProduct = this.concatProductInfo(product);
                connection.writeCommand(new IDvShowText(queryProduct));
            } else {
                String queryProduct = this.concatProductInfo(product);
                connection.writeCommand(new IDvShowText(queryProduct));
            }
        }
    }

    private List<Command> createCommandList(Exhibition exhibition, Product product) {
        LinkedList<Command> cmdList = new LinkedList<Command>();
        cmdList.add(new IDvDispClear(exhibition.getBgColor().getId()));
        cmdList.add(new IDvShowText(product.getBarcode(), exhibition.getBarcode()));
        String description = product.getDescription();
        if (description != null && !description.trim().isEmpty()) {
            cmdList.add(new IDvShowText(product.getDescription(), exhibition.getDescription()));
        }
        GerBotTwoQueryExecutor.formatAndAddPrices(product, cmdList, exhibition);
        return cmdList;
    }

    public String concatProductInfo(Product product) {
        String separator = "|";
        String concat = product.getDescription();
        concat = concat + separator;
        concat = concat + product.getPrice1();
        concat = concat + separator;
        concat = concat + product.getPrice2();
        return concat;
    }

    private Product verifyProduct(Product product) {
        if (product.getDescription() == null) {
            product.setDescription("Problema de descri\u00e7\u00e3o.");
        }
        if (product.getPrice1() == null) {
            product.setPrice1("");
        }
        if (product.getPrice2() == null) {
            product.setPrice2("");
        }
        return product;
    }

    private Product getProductByBarcode(String barcode) {
        Product product = null;
        try {
            product = Product.get(barcode);
            return product;
        }
        catch (DbException e) {
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
            return null;
        }
    }
}

