/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.customer.GenerateImage;
import br.com.gertec.tc.server.customer.GifQueryBPG2;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.Gif;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageData;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageHeader;
import br.com.gertec.tc.server.protocol.sc501.commands.NotFound;
import br.com.gertec.tc.server.protocol.sc501.commands.PlayAudioWithMsg;
import br.com.gertec.tc.server.protocol.sc501.commands.ProductResponse;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.tts.JobGenerateAudio;
import br.com.gertec.tc.server.util.DataBlock;
import br.com.gertec.tc.server.util.Util;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.j18n.J18N;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingWorker;
import org.h2.message.DbException;

public class Sc501QueryExecutor
extends QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc501Query(connection, barcode);
    }

    @Override
    public void execute(AbstractTcConnection connection, String barcode, String dataMatrix) {
        Sc501QueryExecutor.doSc501Query(connection, barcode, dataMatrix);
    }

    private void doSc501Query(final AbstractTcConnection connection, String barcode) {
        String commandMsg = "#playaudiowithmessage".replace("#", "");
        if (barcode.contains(commandMsg)) {
            return;
        }
        try {
            Product product = Product.get(barcode);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                Product produtoClonado = this.clonaProduto(product);
                Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
                Exhibition productExhibition = ProductExhibition.get(barcode, connection.getTerminalType());
                boolean hasProductExhibition = productExhibition != null;
                boolean isServerImage = false;
                if (hasProductExhibition) {
                    Exhibition.MediaType mediaTerminal = productExhibition.getMediaType();
                    isServerImage = mediaTerminal.equals((Object)Exhibition.MediaType.SERVER_IMAGE);
                } else if (connection.getTerminalType() != TerminalType.TC_502) {
                    boolean bl = isServerImage = defaultExhibition.getMediaType().equals((Object)Exhibition.MediaType.SERVER_IMAGE);
                }
                if (connection.getTerminalType() == TerminalType.TC_406) {
                    String description = product.getDescription();
                    String price1 = product.getPrice1();
                    String price2 = product.getPrice2();
                    String priceFormat = this.verifyQueryPriceG2(Util.convertToValidCurrencyFormat(price1), Util.convertToValidCurrencyFormat(price2));
                    description = this.verifyQueryDescG2(description);
                    price1 = this.verifyQueryPriceG2(price1, price2);
                    GifQueryBPG2 queryGif = new GifQueryBPG2();
                    if (queryGif.searchGif(barcode, connection.getTerminalType())) {
                        queryGif.getQueryGif(barcode, product.getDescription(), product.getPrice1(), product.getPrice2());
                        File generatedGif = new File("QueryImage.gif");
                        connection.writeCommand(new Gif(generatedGif, Gif.ExhibitionMode.QUERY, 0, queryGif.getTime()));
                    } else if (defaultExhibition.getMediaType() == Exhibition.MediaType.SERVER_IMAGE) {
                        queryGif.getGifQueryStandard(barcode, product, defaultExhibition);
                        File generatedGif = new File("QueryImageStandard.gif");
                        connection.writeCommand(new Gif(generatedGif, Gif.ExhibitionMode.QUERY, 0, 5));
                    } else if (VersionsWithAudio.isTC406Audio(connection.getTerminal().getTerminalVersion()) && DataBlock.verifyDate()) {
                        try {
                            JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioQueryG2(description, priceFormat, connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                            if (!returnValue.isFromICTS()) {
                                Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                            }
                            File audio = returnValue.getAudioFinalFile();
                            PlayAudioWithMsg commandAudio = new PlayAudioWithMsg("#playaudiowithmessage");
                            commandAudio.setAudioHeader(true, audio, this.getTimeAudioMp3(audio.length()), (short)3, description, price1);
                            final byte[] audioBytes = this.getBytes(audio);
                            connection.writeCommand(commandAudio);
                            Runnable sendAudio = new Runnable(){

                                @Override
                                public void run() {
                                    connection.write(audioBytes);
                                }
                            };
                            Executors.newSingleThreadScheduledExecutor().schedule(sendAudio, 2000L, TimeUnit.MILLISECONDS);
                        }
                        catch (UnsupportedAudioFileException e) {
                            e.printStackTrace();
                        }
                    } else {
                        connection.writeCommand(new ProductResponse(produtoClonado));
                    }
                } else if ((connection.getTerminalType() == TerminalType.TC_507 || connection.getTerminalType() == TerminalType.TC_505) && isServerImage) {
                    try {
                        GenerateImage gImage = new GenerateImage(produtoClonado.getDescription(), produtoClonado.getPrice1(), produtoClonado.getPrice2(), 128, 64);
                        File file = new File("QueryImage.bmp");
                        gImage.getFileQueryImage();
                        this.sendImageQueryFromFile(connection, file);
                    }
                    catch (IOException iOException) {}
                } else {
                    produtoClonado.setDescription(this.checkDescription(produtoClonado.getDescription()));
                    connection.writeCommand(new ProductResponse(produtoClonado));
                }
            } else if (VersionsWithAudio.isTC406Audio(connection.getTerminal().getTerminalVersion()) && connection.getTerminalType() == TerminalType.TC_406 && DataBlock.verifyDate()) {
                try {
                    JobGenerateAudio.ReturnValues returnValue = GenerateAudioImpl.getAudioNotFoundG2("Produto n\u00e3o encontrado", connection.getTerminal().getMacAddress().replaceAll("[^a-zA-Z0-9]", ""));
                    if (!returnValue.isFromICTS()) {
                        Log.warningTag("QUERY", J18N.tr("Audio server problem. A default audio will be sent.", new Object[0]), new Object[0]);
                    }
                    final File audio = returnValue.getAudioFinalFile();
                    final PlayAudioWithMsg commandAudio = new PlayAudioWithMsg("#playaudiowithmessage");
                    commandAudio.setAudioHeader(false, audio, this.getTimeAudioMp3(audio.length()), (short)3, null, null);
                    SwingWorker<Void, Void> sw1 = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            connection.writeCommand(commandAudio);
                            Thread.sleep(2000L);
                            return null;
                        }

                        @Override
                        protected void done() {
                            connection.write(Sc501QueryExecutor.this.getBytes(audio));
                        }
                    };
                    sw1.execute();
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
            } else {
                connection.writeCommand(new NotFound());
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
    }

    private static void doSc501Query(AbstractTcConnection connection, String barcode, String dataMatrix) {
        try {
            String dataMatrixTratada;
            boolean isDataMatrix;
            Product product = Product.get(barcode);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                connection.writeCommand(new ProductResponse(product));
                Thread.sleep(2000L);
            }
            if (isDataMatrix = Application.checkDataMatrix(dataMatrixTratada = dataMatrix.substring(1))) {
                connection.writeCommand(new ProductResponse(dataMatrixTratada.split("\u001d")));
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
        }
        catch (InterruptedException ex) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Problema na leitura do c\u00f3digo 2D: %s", new Object[0]), ex.getMessage());
        }
    }

    private Product clonaProduto(Product product) {
        Product produtoClonado = new Product();
        produtoClonado.setBarcode(product.getBarcode());
        produtoClonado.setDescription(product.getDescription());
        produtoClonado.setPrice1(product.getPrice1());
        produtoClonado.setPrice2(product.getPrice2());
        return produtoClonado;
    }

    private String verifyQueryDescG2(String desc) {
        if (desc.length() > 80) {
            String[] oldDesc = desc.split("");
            String newDesc = "";
            for (int i = 0; i < 80; ++i) {
                newDesc = newDesc + oldDesc[i];
            }
            return newDesc;
        }
        return desc;
    }

    private String verifyQueryPriceG2(String price1, String price2) {
        String prices = price1 + " " + price2;
        if (prices.length() > 20) {
            String[] oldPrice = prices.split("");
            String newPrice = "";
            for (int i = 0; i < 20; ++i) {
                newPrice = newPrice + oldPrice[i];
            }
            return newPrice;
        }
        return prices;
    }

    private short getTimeAudioMp3(long len) {
        int magicNumber = 10000;
        short timeAudio = (short)((int)len / magicNumber);
        return timeAudio;
    }

    private byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
            inFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("APPLICATION -- " + fnfex.getMessage());
        }
        catch (IOException ioex) {
            System.out.println("APPLICATION -- " + ioex.getMessage());
        }
        return sendBuf;
    }

    private void sendImageQueryFromFile(AbstractTcConnection connection, File file) throws IOException {
        BufferedImage originalImage = ImageIO.read(file);
        ImageHeader img = new ImageHeader();
        img.setHeader(0, 0, 5, 1, (int)file.length(), 0);
        ImageData imgData = new ImageData();
        imgData.setFrame(originalImage, (short)1);
        connection.writeCommand(img);
        connection.writeCommand(imgData);
    }

    private String checkDescription(String description) {
        if (description.contains("%")) {
            String produtoTratado = "";
            String[] aux = description.split("");
            String x = description;
            for (int i = 0; i < x.length(); ++i) {
                char ch = x.charAt(i);
                String x1 = String.valueOf(ch);
                produtoTratado = x1.equalsIgnoreCase("%") ? produtoTratado + aux[i] + "%" : produtoTratado + aux[i];
            }
            return produtoTratado;
        }
        return description;
    }
}

