/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.query;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.customer.GenerateImage;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageData;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageHeader;
import br.com.gertec.tc.server.protocol.sc501.commands.NotFound;
import br.com.gertec.tc.server.protocol.sc501.commands.ProductResponse;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.org.reconcavo.j18n.J18N;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.h2.message.DbException;

public class TC506QueryExecutor
extends QueryExecutor {
    @Override
    public void execute(AbstractTcConnection connection, String barcode) {
        this.doSc501Query(connection, barcode);
    }

    @Override
    public void execute(AbstractTcConnection connection, String barcode, String dataMatrix) {
        TC506QueryExecutor.doSc501Query(connection, barcode, dataMatrix);
    }

    private void doSc501Query(AbstractTcConnection connection, String barcode) {
        String commandMsg = "#playaudiowithmessage".replace("#", "");
        if (barcode.contains(commandMsg)) {
            return;
        }
        try {
            Product product = Product.get(barcode);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                Product produtoClonado = this.clonaProduto(product);
                Exhibition defaultExhibition = Application.SETTINGS.getDefaultExhibition(connection.getTerminalType());
                Exhibition productExhibition = ProductExhibition.get(barcode, connection.getTerminalType());
                boolean hasProductExhibition = productExhibition != null;
                boolean isServerImage = false;
                if (hasProductExhibition) {
                    Exhibition.MediaType mediaTerminal = productExhibition.getMediaType();
                    isServerImage = mediaTerminal.equals((Object)Exhibition.MediaType.SERVER_IMAGE);
                } else {
                    boolean bl = isServerImage = defaultExhibition.getMediaType().equals((Object)Exhibition.MediaType.SERVER_IMAGE);
                }
                if ((connection.getTerminalType() == TerminalType.TC_507 || connection.getTerminalType() == TerminalType.TC_505) && isServerImage) {
                    try {
                        GenerateImage gImage = new GenerateImage(produtoClonado.getDescription(), produtoClonado.getPrice1(), produtoClonado.getPrice2(), 128, 64);
                        File file = new File("QueryImage.bmp");
                        gImage.getFileQueryImage();
                        this.sendImageQueryFromFile(connection, file);
                    }
                    catch (IOException iOException) {}
                } else {
                    produtoClonado.setDescription(this.checkDescription(produtoClonado.getDescription()));
                    connection.writeCommand(new ProductResponse(produtoClonado));
                }
            } else {
                connection.writeCommand(new NotFound());
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Perda de conex\u00e3o com o banco : %s", new Object[0]), e.getMessage());
        }
    }

    private static void doSc501Query(AbstractTcConnection connection, String barcode, String dataMatrix) {
        try {
            String dataMatrixTratada;
            boolean isDataMatrix;
            Product product = Product.get(barcode);
            Application.logQuery(connection.getInetAddress(), product, barcode);
            if (product != null) {
                if (product.getDescription() == null) {
                    product.setDescription("Problema de descri\u00e7\u00e3o.");
                }
                if (product.getPrice1() == null) {
                    product.setPrice1("R$");
                }
                connection.writeCommand(new ProductResponse(product));
                Thread.sleep(2000L);
            }
            if (isDataMatrix = Application.checkDataMatrix(dataMatrixTratada = dataMatrix.substring(1))) {
                connection.writeCommand(new ProductResponse(dataMatrixTratada.split("\u001d")));
            }
        }
        catch (DbException e) {
            connection.writeCommand(new NotFound());
        }
        catch (InterruptedException ex) {
            connection.writeCommand(new NotFound());
            Log.warningTag("QUERY", J18N.tr("Problema na leitura do c\u00f3digo 2D: %s", new Object[0]), ex.getMessage());
        }
    }

    private Product clonaProduto(Product product) {
        Product produtoClonado = new Product();
        produtoClonado.setBarcode(product.getBarcode());
        produtoClonado.setDescription(product.getDescription());
        produtoClonado.setPrice1(product.getPrice1());
        produtoClonado.setPrice2(product.getPrice2());
        return produtoClonado;
    }

    private void sendImageQueryFromFile(AbstractTcConnection connection, File file) throws IOException {
        BufferedImage originalImage = ImageIO.read(file);
        ImageHeader img = new ImageHeader();
        img.setHeader(0, 0, 5, 1, (int)file.length(), 0);
        ImageData imgData = new ImageData();
        imgData.setFrame(originalImage, (short)1);
        connection.writeCommand(img);
        connection.writeCommand(imgData);
    }

    private String checkDescription(String description) {
        if (description.contains("%")) {
            String produtoTratado = "";
            String[] aux = description.split("");
            String x = description;
            for (int i = 0; i < x.length(); ++i) {
                char ch = x.charAt(i);
                String x1 = String.valueOf(ch);
                produtoTratado = x1.equalsIgnoreCase("%") ? produtoTratado + aux[i] + "%" : produtoTratado + aux[i];
            }
            return produtoTratado;
        }
        return description;
    }
}

