/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.tts;

import br.com.rybena.tts.api.TTSClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.concurrent.Callable;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JobGenerateAudio
implements Callable<Object> {
    public static Integer AUDIO_TIMEOUT = 2;
    private String text;
    private static String audioRelativeDir = "offlineAudio/";
    private static String productNotFoundFile = audioRelativeDir + "productNotFound_";

    public JobGenerateAudio(String messageText) {
        this.text = messageText;
    }

    private static String getLocale() {
        File appDir = new File(System.getProperty("user.home"), ".tc-server");
        String locale = "pt-BR";
        if (appDir.exists()) {
            try {
                Scanner scanner = new Scanner(new File(appDir, "config.properties"));
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.contains("LOCALE=")) continue;
                    locale = line.substring(7);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return locale;
    }

    private AudioInputStream getAudioFromICTS() throws Throwable {
        TTSClient ttsClient = TTSClient.newDefaultClient();
        return ttsClient.speak(this.text);
    }

    public static ReturnValues getAudioFromLocalFile() {
        AudioInputStream audioStream = null;
        ClassLoader classLoader = JobGenerateAudio.class.getClassLoader();
        InputStream in = classLoader.getResourceAsStream(audioRelativeDir + JobGenerateAudio.getLocale() + ".mp3");
        try {
            audioStream = AudioSystem.getAudioInputStream(new BufferedInputStream(in));
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        return new ReturnValues(audioStream, false);
    }

    @Override
    public ReturnValues call() throws Exception {
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = this.getAudioFromICTS();
            return new ReturnValues(audioInputStream, true);
        }
        catch (Throwable e) {
            return JobGenerateAudio.getAudioFromLocalFile();
        }
    }

    public static class ReturnValues {
        private final AudioInputStream audioStream;
        private final boolean isFromICTS;
        private File audioFinalFile;

        public ReturnValues(AudioInputStream audioStream, boolean success) {
            this.audioStream = audioStream;
            this.isFromICTS = success;
        }

        public void setAudioFinalFile(File file) {
            this.audioFinalFile = file;
        }

        public File getAudioFinalFile() {
            return this.audioFinalFile;
        }

        public AudioInputStream getAudioStream() {
            return this.audioStream;
        }

        public boolean isFromICTS() {
            return this.isFromICTS;
        }
    }
}

