/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import java.io.File;
import java.io.IOException;

public class FileUtilities {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final String TMP_BASE_DIR_NAME = "tmpTcFiles";
    private static final String TMP_MEDIA_DIR_NAME = "medias";
    private static final String TMP_CONFIG_FOLDER = "configs";
    private static final String TMP_CUSTOMER_FOLDER = "customer";
    private static final String TMP_AUDIO_FOLDER = "audio";
    private static FileUtilities singleton;

    public static FileUtilities getInstance() {
        if (singleton == null) {
            singleton = new FileUtilities();
        }
        return singleton;
    }

    private File makeTempDir(String dirName) throws IllegalStateException {
        File tmpDir = new File(this.getTemporaryBaseDir(), dirName);
        if (tmpDir.exists()) {
            return tmpDir;
        }
        if (!tmpDir.mkdirs()) {
            try {
                throw new RuntimeException("Cannot create temporary directory: " + tmpDir.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return tmpDir;
    }

    public File getTemporaryBaseDir() {
        File tmpDir = new File(TMP_DIR, TMP_BASE_DIR_NAME);
        if (tmpDir.exists()) {
            return tmpDir;
        }
        if (!tmpDir.mkdirs()) {
            try {
                throw new RuntimeException("Cannot create temporary directory: " + tmpDir.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return tmpDir;
    }

    public File getTemporaryMediaDir() {
        return this.makeTempDir(TMP_MEDIA_DIR_NAME);
    }

    public File getTemporaryConfigDir() {
        return this.makeTempDir(TMP_CONFIG_FOLDER);
    }

    public void deleteTemporaryBaseDir() {
        File tempDir = new File(TMP_DIR, TMP_BASE_DIR_NAME);
        this.cleanDirectory(tempDir);
    }

    public void deleteTemporaryMediaDir() {
        this.cleanDirectory(this.getTemporaryMediaDir());
    }

    public void deleteTemporaryConfigDir() {
        this.cleanDirectory(this.getTemporaryConfigDir());
    }

    private void cleanDirectory(File directory) {
        if (!directory.isDirectory()) {
            directory.delete();
            return;
        }
        if (!directory.delete()) {
            String[] entries;
            for (String s : entries = directory.list()) {
                File currentFile = new File(directory.getPath(), s);
                if (currentFile.isDirectory()) {
                    this.cleanDirectory(currentFile);
                }
                currentFile.delete();
            }
        }
    }

    public File getTemporaryCustomer() {
        return this.makeTempDir(TMP_CUSTOMER_FOLDER);
    }

    public File getTemporaryAudio() {
        return this.makeTempDir(TMP_AUDIO_FOLDER);
    }
}

