/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.util.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrouppedSettings {
    private static final Pattern SECTION_PATTERN = Pattern.compile(String.format("^\\[(%s)\\]$", "[a-zA-Z][a-zA-Z\\.0-9_]*"));
    private static final Pattern ENTRY_PATTERN = Pattern.compile(String.format("^%s=.+", "[a-zA-Z][a-zA-Z\\.0-9_]*"));
    private final Map<String, Settings> sectionMap = new LinkedHashMap<String, Settings>();

    public static GrouppedSettings loadListMedias(String file) throws IOException {
        GrouppedSettings settings = new GrouppedSettings();
        String[] tokens = file.split("\r\n", 15);
        for (int count = 0; count < tokens.length; ++count) {
            if (!tokens[count].contains(".jpg") && !tokens[count].contains(".jpeg") && !tokens[count].contains(".bmp")) continue;
            settings.setProperty("INT_MEM", "media_" + String.valueOf(count), tokens[count]);
        }
        return settings;
    }

    public static GrouppedSettings loadListMediaConf(String file) throws IOException {
        GrouppedSettings settings = new GrouppedSettings();
        String[] tokens = file.split("\n");
        int countMedia = 0;
        for (int count = 0; count < tokens.length; ++count) {
            if (!tokens[count].contains(".jpg") && !tokens[count].contains(".jpeg") && !tokens[count].contains(".bmp")) continue;
            String fileCnv = tokens[count].replaceFirst("media_" + String.valueOf(countMedia) + "=", "");
            String[] cnv = fileCnv.split("\\|");
            settings.setProperty("INT_MEM", "media_" + String.valueOf(count), cnv[0]);
            ++countMedia;
        }
        return settings;
    }

    public static GrouppedSettings load(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));){
            String line;
            GrouppedSettings settings = new GrouppedSettings();
            String currentGroupName = null;
            int i = 1;
            while ((line = br.readLine()) != null) {
                Matcher m = SECTION_PATTERN.matcher(line = line.trim());
                if (m.find()) {
                    currentGroupName = m.group(1);
                } else if (line.matches(ENTRY_PATTERN.pattern())) {
                    String[] tokens = line.split("=", 2);
                    settings.setProperty(currentGroupName, tokens[0], tokens[1]);
                } else if (!line.isEmpty()) {
                    throw new IOException("Invalid entry at line " + i);
                }
                ++i;
            }
            GrouppedSettings grouppedSettings = settings;
            return grouppedSettings;
        }
    }

    public synchronized boolean containsSection(String name) {
        return this.sectionMap.containsKey(name);
    }

    public synchronized Settings getSection(String name) {
        return this.sectionMap.get(name);
    }

    public synchronized boolean removeSection(String name) {
        return this.sectionMap.remove(name) != null;
    }

    public synchronized boolean clear() {
        if (this.sectionMap.isEmpty()) {
            return false;
        }
        for (Settings settings : this.sectionMap.values()) {
            settings.clear();
        }
        this.sectionMap.clear();
        return true;
    }

    public final synchronized boolean containsProperty(String key) {
        return this.containsProperty(null, key);
    }

    public synchronized boolean containsProperty(String section, String key) {
        return this.containsSection(section) && this.getSection(section).containsKey(key);
    }

    public final synchronized boolean removeProperty(String key) {
        return this.removeProperty(null, key);
    }

    public synchronized boolean removeProperty(String section, String key) {
        if (this.containsSection(section)) {
            Settings mSection = this.getSection(section);
            boolean removed = mSection.removeProperty(key);
            if (mSection.isEmpty()) {
                this.removeSection(section);
            }
            return removed;
        }
        return false;
    }

    public final synchronized boolean setProperty(String key, String value) {
        return this.setProperty(null, key, value);
    }

    public synchronized boolean setProperty(String section, String key, String value) {
        if (section != null && !section.matches(Settings.KEY_PATTERN.pattern())) {
            throw new IllegalArgumentException("Invalid section name: " + section);
        }
        Settings mSection = this.getSection(section);
        if (mSection == null) {
            mSection = new Settings();
            mSection.setProperty(key, value);
            this.sectionMap.put(section, mSection);
            return true;
        }
        return mSection.setProperty(key, value);
    }

    public final synchronized boolean setPropertyIfAbsent(String key, String value) {
        return this.setPropertyIfAbsent(null, key, value);
    }

    public synchronized boolean setPropertyIfAbsent(String section, String key, String value) {
        if (this.containsProperty(section, key)) {
            return false;
        }
        return this.setProperty(section, key, value);
    }

    public final synchronized String getProperty(String key, String defaultValue) {
        return this.getProperty(null, key, defaultValue);
    }

    public synchronized String getProperty(String section, String key, String defaultValue) {
        if (!this.containsProperty(section, key)) {
            return defaultValue;
        }
        return this.getSection(section).getProperty(key, defaultValue);
    }

    public final synchronized String getMandatoryProperty(String key) {
        return this.getMandatoryProperty(null, key);
    }

    public synchronized String getMandatoryProperty(String section, String key) {
        if (!this.containsProperty(section, key)) {
            throw new Settings.PropertyNotFoundException(String.format("%s/%s", section, key));
        }
        return this.getSection(section).getMandatoryProperty(key);
    }

    public final synchronized void store(File outputFile) throws IOException {
        this.store(outputFile, true);
    }

    public synchronized void store(File outputFile, boolean overwrite) throws IOException {
        if (outputFile.exists() && !overwrite) {
            throw new IOException("File already exists: " + outputFile.getAbsolutePath());
        }
        int i = 0;
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            for (Map.Entry<String, Settings> entry : this.sectionMap.entrySet()) {
                String sectionName = entry.getKey();
                if (sectionName != null) {
                    fos.write(String.format("%s[%s]\n", i == 0 ? "" : "\n", sectionName).getBytes("utf-8"));
                }
                Settings mSettings = entry.getValue();
                mSettings.store(fos);
                ++i;
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.sectionMap);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GrouppedSettings other = (GrouppedSettings)obj;
        return Objects.equals(this.sectionMap, other.sectionMap);
    }

    public Set<Map.Entry<String, Settings>> entrySet() {
        return this.sectionMap.entrySet();
    }
}

