/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.util.ImageFrame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadataNode;

public class ImageUtils {
    private static final int GIF_METADATA = 1195984440;
    private static ImageUtils singleton = null;

    public static ImageUtils getInstance() {
        if (singleton == null) {
            singleton = new ImageUtils();
        }
        return singleton;
    }

    private ImageUtils() {
    }

    public void resize(List<ImageFrame> original, int newWidth, int newHeight) {
        for (ImageFrame frame : original) {
            frame.setData(this.resize(frame.getBufferedImage(), newWidth, newHeight));
        }
    }

    public void crop(List<ImageFrame> original, int xStart, int yStart, int width, int height) {
        for (ImageFrame frame : original) {
            frame.setData(this.crop(frame.getBufferedImage(), xStart, yStart, width, height));
        }
    }

    public void toBinary(List<ImageFrame> original, int threshold) {
        boolean isGif = false;
        if (original.size() > 1) {
            isGif = true;
        }
        for (ImageFrame frame : original) {
            if (isGif) {
                frame.setData(this.toG2DBinary(frame.getBufferedImage()));
                continue;
            }
            frame.setData(this.toBinary(frame.getBufferedImage(), threshold));
        }
    }

    public BufferedImage toG2DBinary(BufferedImage original) {
        Raster originalRaster = original.getData();
        int width = originalRaster.getWidth();
        int height = originalRaster.getHeight();
        BufferedImage result = new BufferedImage(width, height, 12);
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        return result;
    }

    public BufferedImage toBinary(BufferedImage original, int threshold) {
        int step = threshold;
        int min = 0;
        int max = 1;
        Raster originalRaster = original.getData();
        int width = originalRaster.getWidth();
        int height = originalRaster.getHeight();
        BufferedImage result = new BufferedImage(width, height, 12);
        WritableRaster resultRaster = result.getRaster();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pix = originalRaster.getPixel(x, y, (int[])null)[0];
                if (pix < step) {
                    resultRaster.setPixel(x, y, new int[]{max});
                    continue;
                }
                resultRaster.setPixel(x, y, new int[]{min});
            }
        }
        return result;
    }

    public static void toGrayscale(BufferedImage img) {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgb = img.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int grayLevel = (r + g + b) / 3;
                int gray = (grayLevel << 16) + (grayLevel << 8) + grayLevel;
                img.setRGB(x, y, gray);
            }
        }
    }

    public ArrayList<ImageFrame> getFrames(File imageFile) throws IOException {
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>();
        if (this.isGif(imageFile).booleanValue()) {
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(ImageIO.createImageInputStream(imageFile));
            for (int i = 0; i < reader.getNumImages(true); ++i) {
                IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree("javax_imageio_gif_image_1.0");
                IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                int delay = Integer.valueOf(gce.getAttribute("delayTime")) / 10;
                BufferedImage originalFrame = reader.read(i);
                frames.add(new ImageFrame(originalFrame, (short)delay));
            }
        } else {
            short delay = 0;
            BufferedImage img = ImageIO.read(imageFile);
            frames.add(new ImageFrame(img, delay));
        }
        return frames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isGif(File file) {
        try (DataInputStream ins = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            Boolean bl = ins.readInt() == 1195984440;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isStaticGif(File file) {
        try {
            if (!this.isGif(file).booleanValue()) {
                throw new IllegalArgumentException("File is not a GIF");
            }
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            reader.setInput(ImageIO.createImageInputStream(file));
            return reader.getNumImages(true) == 1;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BufferedImage resize(BufferedImage img, int newWidth, int newHeight) {
        Image tmp = img.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, img.getType());
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public BufferedImage crop(BufferedImage src, int xStart, int yStart, int width, int height) {
        BufferedImage cropped = new BufferedImage(width, height, src.getType());
        Graphics2D g2d = cropped.createGraphics();
        g2d.drawImage((Image)src, xStart, yStart, null);
        g2d.dispose();
        return cropped;
    }

    public byte[] getChecksum(File file) throws FileNotFoundException, IOException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            try (FileInputStream is = new FileInputStream(file);
                 DigestInputStream dis = new DigestInputStream(is, md);){
                while (true) {
                    int read = 0;
                    read = dis.read(buffer);
                    if (read == -1) break;
                    md.update(buffer, 0, read);
                }
                ((InputStream)is).close();
                dis.close();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] digest = md.digest();
        return digest;
    }
}

