/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.util.Resources;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFDocumentDrawer {
    private PDDocument document;
    private String filename;

    public PDFDocumentDrawer(String filename) {
        this.setFilename(filename);
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<BufferedImage> open() throws FileNotFoundException, IOException {
        InputStream file = Resources.getInputStream(this.getFilename());
        ArrayList<BufferedImage> imagePages = new ArrayList<BufferedImage>();
        try {
            this.document = PDDocument.load(file);
            PDFRenderer renderer = new PDFRenderer(this.document);
            for (PDPage page : this.document.getPages()) {
                BufferedImage image = renderer.renderImage(this.document.getPages().indexOf(page));
                imagePages.add(image);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imagePages;
    }

    public void close() {
        try {
            this.document.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

