/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.util.NamedColor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Palette {
    private static final Map<Short, NamedColor> DEFAULT_PALETTE;
    public static final List<NamedColor> DEFAULT_COLORS;
    private static Palette singleton;
    private final Map<Short, NamedColor> colorMap = new LinkedHashMap<Short, NamedColor>();

    public static Palette getInstance() {
        if (singleton == null) {
            singleton = new Palette();
        }
        return singleton;
    }

    private Palette() {
    }

    public void putColor(short id, NamedColor color) {
        this.colorMap.put(id, color);
    }

    public short getRandomColorId() {
        Random rng = new Random();
        int result = rng.nextInt(15) + 256;
        return this.getColorId(this.getColor((short)result));
    }

    public NamedColor getColor(Short id) {
        if (id == null) {
            return null;
        }
        NamedColor color = this.colorMap.get(id);
        if (color == null) {
            color = DEFAULT_PALETTE.get(id);
        }
        return color;
    }

    public Short getColorId(String colorName) {
        return this.getColorId(NamedColor.fromName(colorName));
    }

    public Short getColorId(NamedColor color) {
        if (color == null) {
            return null;
        }
        for (Map.Entry<Short, NamedColor> entry : this.colorMap.entrySet()) {
            if (!entry.getValue().equals((Object)color)) continue;
            return entry.getKey();
        }
        for (Map.Entry<Short, NamedColor> entry : DEFAULT_PALETTE.entrySet()) {
            if (!entry.getValue().equals((Object)color)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        LinkedHashMap<Short, NamedColor> defaultPalette = new LinkedHashMap<Short, NamedColor>();
        defaultPalette.put((short)256, NamedColor.BLACK);
        defaultPalette.put((short)257, NamedColor.BROWN);
        defaultPalette.put((short)258, NamedColor.GREEN);
        defaultPalette.put((short)259, NamedColor.OLIVE);
        defaultPalette.put((short)260, NamedColor.NAVY);
        defaultPalette.put((short)261, NamedColor.PURPLE);
        defaultPalette.put((short)262, NamedColor.METALLIC);
        defaultPalette.put((short)263, NamedColor.GREY);
        defaultPalette.put((short)264, NamedColor.SILVER);
        defaultPalette.put((short)265, NamedColor.RED);
        defaultPalette.put((short)266, NamedColor.LIME);
        defaultPalette.put((short)267, NamedColor.YELLOW);
        defaultPalette.put((short)268, NamedColor.BLUE);
        defaultPalette.put((short)269, NamedColor.FUCHSIA);
        defaultPalette.put((short)270, NamedColor.WATER);
        defaultPalette.put((short)271, NamedColor.WHITE);
        defaultPalette.put((short)-1, NamedColor.TRANSPARENT);
        DEFAULT_PALETTE = Collections.unmodifiableMap(defaultPalette);
        LinkedList<NamedColor> defaultColors = new LinkedList<NamedColor>(DEFAULT_PALETTE.values());
        Collections.sort(defaultColors);
        DEFAULT_COLORS = Collections.unmodifiableList(defaultColors);
        singleton = null;
    }
}

