/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.bean.Slide;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Playlist {
    private Playlist() {
    }

    private static List<String> getPathList(File playlistFile) {
        LinkedList<String> stringList = new LinkedList<String>();
        if (playlistFile.exists()) {
            try {
                FileReader fileReader = new FileReader(playlistFile);
                BufferedReader br = new BufferedReader(fileReader);
                while (br.ready()) {
                    String s = br.readLine();
                    if (s.startsWith("<") || s.startsWith(">")) continue;
                    stringList.add(s);
                }
                br.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return stringList;
    }

    private static List<Slide> loadSlideList(List<String> pathList) {
        LinkedList<Slide> slideList = new LinkedList<Slide>();
        for (String nonProcessedPath : pathList) {
            int repetitions;
            int duration;
            String[] stringList = nonProcessedPath.split("\\|");
            if (stringList.length < 4) continue;
            String mainFile = stringList[1];
            String memory = "";
            if (mainFile.contains("/")) {
                memory = stringList[1].split("/")[0];
            }
            try {
                duration = Integer.parseInt(stringList[2]);
            }
            catch (NumberFormatException ex) {
                duration = 0;
            }
            try {
                repetitions = Integer.parseInt(stringList[3]);
            }
            catch (NumberFormatException ex) {
                repetitions = 0;
            }
            if (stringList.length != 4) continue;
            Slide slide = new Slide(mainFile, memory, duration, repetitions);
            slideList.add(slide);
        }
        return slideList;
    }

    public static List<Slide> load(File playlistFile) {
        List<String> pathList = Playlist.getPathList(playlistFile);
        List<Slide> slideList = Playlist.loadSlideList(pathList);
        return slideList;
    }

    public static List<Slide> loadMediaConf(String file) {
        LinkedList<Slide> slideList = new LinkedList<Slide>();
        String[] tokens = file.split("\n");
        int countMedia = 0;
        for (int count = 0; count < tokens.length; ++count) {
            if (!tokens[count].contains(".jpg") && !tokens[count].contains(".jpeg") && !tokens[count].contains(".bmp")) continue;
            String fileCnv = tokens[count].replaceFirst("media_" + String.valueOf(countMedia) + "=", "");
            String[] cnv = fileCnv.split("\\|");
            Slide slide = new Slide(cnv[0], "INT_MEM", Integer.parseInt(cnv[1]), Integer.parseInt(cnv[2]));
            slideList.add(slide);
            ++countMedia;
        }
        return slideList;
    }
}

