/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class Settings {
    static final String KEY_REGEX = "[a-zA-Z][a-zA-Z\\.0-9_]*";
    static final Pattern KEY_PATTERN = Pattern.compile(String.format("^%s$", "[a-zA-Z][a-zA-Z\\.0-9_]*"));
    private final Map<String, String> propertyMap = new LinkedHashMap<String, String>();

    public synchronized boolean containsKey(String key) {
        return this.propertyMap.containsKey(key);
    }

    public synchronized boolean removeProperty(String key) {
        return this.propertyMap.remove(key) != null;
    }

    public synchronized boolean setProperty(String key, String value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty key");
        }
        if (!key.matches(KEY_PATTERN.pattern())) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        if (Objects.equals(value, this.propertyMap.get(key))) {
            return false;
        }
        this.propertyMap.put(key, value);
        return true;
    }

    public synchronized boolean setPropertyIfAbsent(String key, String value) {
        if (this.containsKey(key)) {
            return false;
        }
        return this.setProperty(key, value);
    }

    public synchronized boolean setProperties(Settings other) {
        boolean result = false;
        for (Map.Entry<String, String> entry : other.entrySet()) {
            result = result || this.propertyMap.containsKey(entry.getKey());
            this.propertyMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public synchronized boolean setPropertiesIfAbsent(Settings other) {
        boolean result = false;
        for (Map.Entry<String, String> entry : other.entrySet()) {
            if (this.propertyMap.containsKey(entry.getKey())) continue;
            result = true;
            this.propertyMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public synchronized String getProperty(String key, String defaultValue) {
        if (!this.propertyMap.containsKey(key)) {
            return defaultValue;
        }
        return this.propertyMap.get(key);
    }

    public synchronized String getMandatoryProperty(String key) throws PropertyNotFoundException {
        String value = this.getProperty(key, null);
        if (value == null) {
            throw new PropertyNotFoundException(key);
        }
        return value;
    }

    public synchronized boolean clear() {
        if (this.propertyMap.isEmpty()) {
            return false;
        }
        this.propertyMap.clear();
        return true;
    }

    public synchronized boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    void store(OutputStream os) throws IOException {
        for (Map.Entry<String, String> entry : this.propertyMap.entrySet()) {
            String line = String.format("%s=%s\n", entry.getKey(), entry.getValue());
            os.write(line.getBytes("utf-8"));
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.propertyMap);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Settings other = (Settings)obj;
        return Objects.equals(this.propertyMap, other.propertyMap);
    }

    public synchronized Set<Map.Entry<String, String>> entrySet() {
        return this.propertyMap.entrySet();
    }

    public static class PropertyNotFoundException
    extends RuntimeException {
        private final String key;

        PropertyNotFoundException(String key) {
            super("Property not found: " + key);
            this.key = key;
        }

        public final String getKey() {
            return this.key;
        }
    }
}

