/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util;

import br.com.gertec.tc.server.customer.audio.online.util.Paths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class VolumeConfig {
    static final String FILE_CONFIG_AUDIO = "config.audio";
    private static final String KEY_DEFAULT_VOLUME_FFMPEG_BPG2 = "BPG2_FFMPEG";
    private static final double DEFAULT_VOLUME_FFMPEG_BPG2 = 7.0;
    private static final String KEY_DEFAULT_VOLUME_FFMPEG_TC506M = "TC506M_FFMPEG";
    private static final double DEFAULT_VOLUME_FFMPEG_TC506M = 5.0;
    private static final String KEY_DEFAULT_VOLUME_FFMPEG_GBOT = "GBOT_FFMPEG";
    private static final double DEFAULT_VOLUME_FFMPEG_GBOT = 5.0;
    private static final String KEY_DEFAULT_VOLUME_FFMPEG_TC506S = "TC506S_FFMPEG";
    private static final double DEFAULT_VOLUME_FFMPEG_TC506S = 7.0;
    private static final String KEY_DEFAULT_VOLUME_AUDIO_BPG2 = "BPG2_AUDIO";
    private static final short DEFAULT_VOLUME_AUDIO_BPG2 = 3;
    private static final String KEY_DEFAULT_VOLUME_AUDIO_TC506M = "TC506M_AUDIO";
    private static final short DEFAULT_VOLUME_AUDIO_TC506M = 100;
    private static final String KEY_DEFAULT_VOLUME_AUDIO_GBOT = "GBOT_AUDIO";
    private static final short DEFAULT_VOLUME_AUDIO_GBOT = 100;
    private static final String KEY_DEFAULT_VOLUME_AUDIO_TC506S = "TC506S_AUDIO";
    private static final short DEFAULT_VOLUME_AUDIO_TC506S = 3;
    private static final double MAX_VOLUME_FFMPEG = 8.0;
    private static final double MIN_VOLUME_FFMPEG = 1.0;
    private static final short MAX_VOLUME_AUDIO_BPG2 = 3;
    private static final short MIN_VOLUME_AUDIO_BPG2 = 1;
    private static final short MAX_VOLUME_AUDIO_TC506M = 100;
    private static final short MIN_VOLUME_AUDIO_TC506M = 0;
    private static final short MAX_VOLUME_AUDIO_GBOT = 100;
    private static final short MIN_VOLUME_AUDIO_GBOT = 0;
    private static final short MAX_VOLUME_AUDIO_TC506S = 3;
    private static final short MIN_VOLUME_AUDIO_TC506S = 1;
    private static double ffmpegBpg2;
    private static double ffmpegTC506M;
    private static double ffmpegGBot;
    private static double ffmpegTC506S;
    private static short audioBpg2;
    private static short audioTc506m;
    private static short audioGBot;
    private static short audioTc506s;
    private static boolean sucessFfmpeg;
    private static boolean sucessVolume;
    private static boolean isG2;
    private static boolean isTc506M;
    private static boolean isGBot;
    private static boolean isTc506S;

    public static double getFfmpegBpg2() {
        isG2 = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_FFMPEG_BPG2, sucessFfmpeg);
        return ffmpegBpg2;
    }

    public static double getFfmpegTC506M() {
        isTc506M = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_FFMPEG_TC506M, sucessFfmpeg);
        return ffmpegTC506M;
    }

    public static double getFfmpegGBot() {
        isGBot = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_FFMPEG_GBOT, sucessFfmpeg);
        return ffmpegGBot;
    }

    public static double getFfmpegTc506s() {
        isTc506S = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_FFMPEG_TC506S, sucessFfmpeg);
        return ffmpegTC506S;
    }

    public static short getAudioBpg2() {
        isG2 = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_AUDIO_BPG2, sucessVolume);
        return audioBpg2;
    }

    public static short getAudioTc506m() {
        isTc506M = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_AUDIO_TC506M, sucessVolume);
        return audioTc506m;
    }

    public static short getAudioGBot() {
        isGBot = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_AUDIO_GBOT, sucessVolume);
        return audioGBot;
    }

    public static short getAudioTc506s() {
        isTc506S = true;
        VolumeConfig.readFile();
        VolumeConfig.printLog(KEY_DEFAULT_VOLUME_AUDIO_TC506S, sucessVolume);
        return audioTc506s;
    }

    public static void readFile() {
        try {
            String rline;
            File volumeFile = new File(Paths.getAbsolutePath(), FILE_CONFIG_AUDIO);
            if (!volumeFile.exists() || volumeFile == null) {
                BufferedWriter fr = new BufferedWriter(new FileWriter(new File(Paths.getAbsolutePath(), FILE_CONFIG_AUDIO)));
                fr.write("BPG2_FFMPEG=7.0");
                fr.newLine();
                fr.write("BPG2_AUDIO=3");
                fr.newLine();
                fr.write("TC506M_FFMPEG=5.0");
                fr.newLine();
                fr.write("TC506M_AUDIO=100");
                fr.newLine();
                fr.write("GBOT_FFMPEG=5.0");
                fr.newLine();
                fr.write("GBOT_AUDIO=100");
                fr.newLine();
                fr.write("TC506S_FFMPEG=7.0");
                fr.newLine();
                fr.write("TC506S_AUDIO=3");
                fr.close();
                ffmpegBpg2 = 7.0;
                audioBpg2 = (short)3;
                ffmpegTC506M = 5.0;
                audioTc506m = (short)100;
                ffmpegGBot = 5.0;
                audioGBot = (short)100;
                ffmpegTC506S = 7.0;
                audioTc506s = (short)3;
                sucessVolume = true;
                sucessFfmpeg = true;
                return;
            }
            BufferedReader buff = new BufferedReader(new FileReader(volumeFile));
            block22: while ((rline = buff.readLine()) != null) {
                String[] rParam = rline.split("=");
                switch (rParam[0]) {
                    case "BPG2_FFMPEG": {
                        if (!isG2) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_FFMPEG_BPG2, rParam[1])) {
                            ffmpegBpg2 = Double.parseDouble(rParam[1]);
                            sucessFfmpeg = true;
                            continue block22;
                        }
                        ffmpegBpg2 = 7.0;
                        sucessFfmpeg = false;
                        continue block22;
                    }
                    case "BPG2_AUDIO": {
                        if (!isG2) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_AUDIO_BPG2, rParam[1])) {
                            audioBpg2 = (short)Integer.parseInt(rParam[1]);
                            sucessVolume = true;
                            continue block22;
                        }
                        audioBpg2 = (short)3;
                        sucessVolume = false;
                        continue block22;
                    }
                    case "TC506M_FFMPEG": {
                        if (!isTc506M) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_FFMPEG_TC506M, rParam[1])) {
                            ffmpegTC506M = Double.parseDouble(rParam[1]);
                            sucessFfmpeg = true;
                            continue block22;
                        }
                        ffmpegTC506M = 5.0;
                        sucessFfmpeg = false;
                        continue block22;
                    }
                    case "TC506M_AUDIO": {
                        if (!isTc506M) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_AUDIO_TC506M, rParam[1])) {
                            audioTc506m = (short)Integer.parseInt(rParam[1]);
                            sucessVolume = true;
                            continue block22;
                        }
                        audioTc506m = (short)100;
                        sucessVolume = false;
                        continue block22;
                    }
                    case "GBOT_FFMPEG": {
                        if (!isGBot) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_FFMPEG_GBOT, rParam[1])) {
                            ffmpegGBot = Double.parseDouble(rParam[1]);
                            sucessFfmpeg = true;
                            continue block22;
                        }
                        ffmpegGBot = 5.0;
                        sucessFfmpeg = false;
                        continue block22;
                    }
                    case "GBOT_AUDIO": {
                        if (!isGBot) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_AUDIO_GBOT, rParam[1])) {
                            audioGBot = (short)Integer.parseInt(rParam[1]);
                            sucessVolume = true;
                            continue block22;
                        }
                        audioGBot = (short)100;
                        sucessVolume = false;
                        continue block22;
                    }
                    case "TC506S_FFMPEG": {
                        if (!isTc506S) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_FFMPEG_TC506S, rParam[1])) {
                            ffmpegTC506S = Double.parseDouble(rParam[1]);
                            sucessFfmpeg = true;
                            continue block22;
                        }
                        ffmpegTC506S = 7.0;
                        sucessFfmpeg = false;
                        continue block22;
                    }
                    case "TC506S_AUDIO": {
                        if (!isTc506S) continue block22;
                        if (VolumeConfig.checkValue(KEY_DEFAULT_VOLUME_AUDIO_TC506S, rParam[1])) {
                            audioTc506s = (short)Integer.parseInt(rParam[1]);
                            sucessVolume = true;
                            continue block22;
                        }
                        audioTc506s = (short)3;
                        sucessVolume = false;
                        continue block22;
                    }
                }
                VolumeConfig.setDefaultValues();
            }
            if (rline == null) {
                VolumeConfig.setDefaultValues();
            }
            buff.close();
        }
        catch (IOException e) {
            VolumeConfig.setDefaultValues();
        }
        isG2 = false;
        isTc506M = false;
        isGBot = false;
        isTc506S = false;
    }

    private static boolean checkValue(String key, String value) {
        try {
            switch (key) {
                case "BPG2_FFMPEG": {
                    return !(Double.parseDouble(value) > 8.0) && !(Double.parseDouble(value) < 1.0);
                }
                case "TC506M_FFMPEG": {
                    return !(Double.parseDouble(value) > 8.0) && !(Double.parseDouble(value) < 1.0);
                }
                case "GBOT_FFMPEG": {
                    return !(Double.parseDouble(value) > 8.0) && !(Double.parseDouble(value) < 1.0);
                }
                case "TC506S_FFMPEG": {
                    return !(Double.parseDouble(value) > 8.0) && !(Double.parseDouble(value) < 1.0);
                }
                case "BPG2_AUDIO": {
                    return (short)Integer.parseInt(value) <= 3 && (short)Integer.parseInt(value) >= 1;
                }
                case "TC506M_AUDIO": {
                    return (short)Integer.parseInt(value) <= 100 && (short)Integer.parseInt(value) >= 0;
                }
                case "GBOT_AUDIO": {
                    return (short)Integer.parseInt(value) <= 100 && (short)Integer.parseInt(value) >= 0;
                }
                case "TC506S_AUDIO": {
                    return (short)Integer.parseInt(value) <= 3 && (short)Integer.parseInt(value) >= 1;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void printLog(String param, boolean sucess) {
        if (!sucess) {
            // empty if block
        }
    }

    private static void printLogExeption() {
    }

    private static void setDefaultValues() {
        ffmpegBpg2 = 7.0;
        audioBpg2 = (short)3;
        ffmpegTC506M = 5.0;
        audioTc506m = (short)100;
        ffmpegGBot = 5.0;
        audioGBot = (short)100;
        ffmpegTC506S = 7.0;
        audioTc506s = (short)3;
        VolumeConfig.printLogExeption();
    }

    static {
        sucessFfmpeg = false;
        sucessVolume = false;
        isG2 = false;
        isTc506M = false;
        isGBot = false;
        isTc506S = false;
    }
}

