/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util.version;

import br.com.gertec.tc.server.protocol.TerminalType;

public class DeviceVersion {
    private static final short MIN_VERSION_RTOS_ALL = 303;
    private static final short MIN_VERSION_BARE_METAL_G2 = 210;
    private static final short MIN_VERSION_TC_506_M = 400;
    private static final short MIN_VERSION_GBOT = 110;

    public static boolean isNewVersion(TerminalType terminal, String version) {
        version = DeviceVersion.removeUnnecessaryText(version);
        int numVersion = Integer.parseInt(version);
        switch (terminal) {
            case TC_406: {
                if (DeviceVersion.isBareMetal(terminal, numVersion)) {
                    return numVersion >= 210 && !version.equals("4.0");
                }
                return true;
            }
            case TC_506_S: {
                return numVersion >= 303;
            }
            case TC_506_MIDIA: {
                return numVersion >= 400;
            }
            case GB_600: {
                return numVersion >= 110;
            }
        }
        return false;
    }

    public static boolean isBareMetal(TerminalType terminal, int version) {
        switch (terminal) {
            case TC_406: {
                return version < 303;
            }
        }
        return true;
    }

    private static String removeUnnecessaryText(String version) {
        version = version.replace(".", "").replace(" ", "");
        version = version.replaceAll("[^\\d.]", "");
        return version;
    }
}

