/*
 * Decompiled with CFR 0.152.
 */
package br.com.rybena.tts.api;

import br.com.rybena.tts.api.exception.ErrorType;
import br.com.rybena.tts.api.exception.ExceptionsError;
import br.com.rybena.tts.api.exception.TTSException;
import javax.sound.sampled.AudioInputStream;

public interface TTSClient {
    public static final String DEFAULT_TTS_CLASS_NAME = "br.com.rybena.tts.api.OnlineTTSClient";
    public static final String DEFAULT_TTS_PROPERTY = "DEFAULT_TTS_CLASS_NAME";

    public TTSType getType();

    public AudioInputStream speak(String var1) throws Throwable;

    public boolean isAlive();

    public static TTSClient newDefaultClient() throws TTSException {
        TTSClient ret = null;
        try {
            Class<TTSClient> ttsC = Class.forName(System.getProperty(DEFAULT_TTS_PROPERTY, DEFAULT_TTS_CLASS_NAME));
            if (ttsC.isAssignableFrom(TTSClient.class)) {
                throw new TTSException(ErrorType.INTERNAL_ERROR, ExceptionsError.IMPLEMENTATION_NOT_FOUND);
            }
            ret = (TTSClient)ttsC.newInstance();
            return ret;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException var2) {
            throw new TTSException(ErrorType.INTERNAL_ERROR, (Throwable)var2);
        }
    }

    public static enum TTSType {
        ONLINE,
        OFFLINE,
        OFFLINE_LINUX,
        OFFLINE_WINDOWS;

    }
}

