/*
 * Decompiled with CFR 0.152.
 */
package br.com.rybena.tts.api.exception;

import br.com.rybena.tts.api.exception.ErrorType;
import br.com.rybena.tts.api.exception.ExceptionsError;
import br.com.rybena.tts.api.exception.errors_msg.ErrorMenssagesProvider;
import java.net.UnknownHostException;

public class TTSException
extends Exception {
    private static final long serialVersionUID = -6121454348554065138L;
    protected static final String TO_STRING_FMT = "%s(COD:%d - %s)";
    protected static final ErrorMenssagesProvider EMP = new ErrorMenssagesProvider();
    protected final String userMessage;
    protected final long errorCode;
    protected final ErrorType errorType;
    protected final ExceptionsError error;

    public TTSException(ErrorType te, ExceptionsError e) {
        this(te, e, null, null);
    }

    public TTSException(ErrorType te, Throwable cause) {
        this(te, TTSException.getErroFromException(cause), cause, cause.getMessage());
    }

    public TTSException(ErrorType te, ExceptionsError e, Throwable cause, String msg) {
        super(msg == null ? EMP.getMessage(te, e) : msg, cause);
        this.userMessage = EMP.getMessage(te, e);
        this.errorCode = te.ordinal() & e.ordinal() >> 16;
        this.errorType = te;
        this.error = e;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return String.format(TO_STRING_FMT, this.userMessage, this.errorCode, this.getMessage());
    }

    public static ExceptionsError getErroFromException(Throwable cause) {
        Throwable localCuase = cause;
        ExceptionsError e = null;
        String messageRoot = cause.getMessage();
        while ((localCuase = localCuase.getCause()) != null) {
            messageRoot = localCuase.getMessage();
        }
        System.out.println(cause.getClass().getName());
        e = cause instanceof UnknownHostException ? ExceptionsError.NO_INTERNET_ACCESS : (messageRoot != null ? (messageRoot.contains("duplicate key") ? ExceptionsError.RESOURCE_DUPLICATED : (messageRoot.contains("violates not-null constraint") ? ExceptionsError.INVALID_PARAMETER : ExceptionsError.UNKNOWN_ERROR)) : ExceptionsError.UNKNOWN_ERROR);
        return e;
    }
}

