/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.event.comm;

import br.org.reconcavo.event.comm.AbstractHeapCommand;
import br.org.reconcavo.event.comm.ByteOrder;
import br.org.reconcavo.event.comm.CommandBuilder;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;

public class SimpleCommand
extends AbstractHeapCommand {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_DATA = new byte[0];
    private final short id;
    private final byte[] data;
    private transient ByteBuffer buffer;

    protected static byte[] getDataArray(boolean b) {
        return new byte[]{b ? (byte)1 : 0};
    }

    protected static byte[] getDataArray(short s) {
        return SimpleCommand.getDataArray(s, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(short s, ByteOrder byteOrder) {
        return ByteBuffer.allocate(2).order(byteOrder.getWrappedValue()).putShort(s).array();
    }

    protected static byte[] getDataArray(int i) {
        return SimpleCommand.getDataArray(i, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(int i, ByteOrder byteOrder) {
        return ByteBuffer.allocate(4).order(byteOrder.getWrappedValue()).putInt(i).array();
    }

    protected static byte[] getDataArray(long l) {
        return SimpleCommand.getDataArray(l, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(long l, ByteOrder byteOrder) {
        return ByteBuffer.allocate(8).order(byteOrder.getWrappedValue()).putLong(l).array();
    }

    protected static byte[] getDataArray(float f) {
        return SimpleCommand.getDataArray(f, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(float f, ByteOrder byteOrder) {
        return ByteBuffer.allocate(4).order(byteOrder.getWrappedValue()).putFloat(f).array();
    }

    protected static byte[] getDataArray(double d) {
        return SimpleCommand.getDataArray(d, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(double d, ByteOrder byteOrder) {
        return ByteBuffer.allocate(8).order(byteOrder.getWrappedValue()).putDouble(d).array();
    }

    protected static byte[] getDataArray(Date date) {
        return SimpleCommand.getDataArray(date, ByteOrder.getNativeOrder());
    }

    protected static byte[] getDataArray(Date date, ByteOrder byteOrder) {
        return SimpleCommand.getDataArray(date.getTime(), byteOrder);
    }

    public SimpleCommand(short id) {
        this(id, null);
    }

    public SimpleCommand(short id, byte[] data) {
        if (data == null) {
            data = EMPTY_DATA;
        }
        this.id = id;
        this.data = data;
        this.buffer = this.getBuffer();
    }

    public short getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    protected ByteOrder getByteOrder() {
        return ByteOrder.getNativeOrder();
    }

    private ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(this.getData());
        }
        return this.buffer;
    }

    @Override
    protected byte[] getSerializedData() {
        byte[] data = this.getData();
        int dataLength = data.length;
        byte[] rawData = new byte[6 + dataLength];
        ByteBuffer rawBuffer = ByteBuffer.wrap(rawData).order(this.getByteOrder().getWrappedValue());
        rawBuffer.putShort(this.getId());
        rawBuffer.putInt(dataLength);
        rawBuffer.put(data);
        return rawBuffer.array();
    }

    protected final boolean readBoolean() {
        return this.getBuffer().get() != 0;
    }

    protected final byte readByte() {
        return this.getBuffer().get();
    }

    protected final short readShort() {
        return this.getBuffer().order(this.getByteOrder().getWrappedValue()).getShort();
    }

    protected final int readInt() {
        return this.getBuffer().order(this.getByteOrder().getWrappedValue()).getInt();
    }

    protected final long readLong() {
        return this.getBuffer().order(this.getByteOrder().getWrappedValue()).getLong();
    }

    protected final float readFloat() {
        return this.getBuffer().order(this.getByteOrder().getWrappedValue()).getFloat();
    }

    protected final double readDouble() {
        return this.getBuffer().order(this.getByteOrder().getWrappedValue()).getDouble();
    }

    protected final Date readDate() {
        return new Date(this.readLong());
    }

    protected final String readString(String charset, int length) throws UnsupportedEncodingException, ArrayIndexOutOfBoundsException {
        int delta = this.getBuffer().remaining() - length;
        if (length < 1 || delta == 0) {
            return new String(this.getBuffer().array(), charset);
        }
        if (delta < 0) {
            throw new ArrayIndexOutOfBoundsException("There is not enough data to fetch the string");
        }
        byte[] data = new byte[length];
        this.getBuffer().get(data);
        return new String(data, charset);
    }

    protected final String readString() {
        return this.readString(-1);
    }

    protected final String readString(int length) {
        try {
            return this.readString(Charset.defaultCharset().name(), length);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return String.format("[id: %d, dataLength: %d]", this.getId(), this.getData().length);
    }

    public static class SimpleCommandBuilder
    implements CommandBuilder {
        private Short currentId = null;
        private Integer dataLength = null;

        protected ByteOrder getByteOrder() {
            return ByteOrder.getNativeOrder();
        }

        @Override
        public boolean canBuild(DataBuffer dataBuffer) {
            ByteOrder byteOrder = this.getByteOrder();
            if (this.currentId == null) {
                if (dataBuffer.available() >= 6) {
                    this.currentId = dataBuffer.readShort(byteOrder);
                    this.dataLength = dataBuffer.readInt(byteOrder);
                    this.onHeaderRead(this.currentId, this.dataLength);
                    return dataBuffer.available() >= this.dataLength;
                }
            } else {
                return dataBuffer.available() >= this.dataLength;
            }
            return false;
        }

        @Override
        public final AbstractHeapCommand getCommand(DataBuffer dataBuffer) {
            byte[] data = dataBuffer.readBytes(this.dataLength);
            try {
                SimpleCommand command = this.getCommand(this.currentId, data);
                return command;
            }
            catch (Throwable error) {
                throw new RuntimeException(String.format("Error building command with id %d", this.currentId), error);
            }
        }

        protected SimpleCommand getCommand(short id, byte[] data) {
            return new SimpleCommand(this.currentId, data);
        }

        protected void onHeaderRead(short id, int dataLength) {
        }

        @Override
        public void reset() {
            this.currentId = null;
            this.dataLength = null;
        }
    }
}

