/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.j18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class J18N {
    private static final List<LocaleChangeListener> LISTENERS = new LinkedList<LocaleChangeListener>();
    private static final Map<Locale, Properties> TRANSLATION_MAP = new LinkedHashMap<Locale, Properties>();
    private static Locale currentLocale = null;
    private static Properties currentTranslations = null;

    protected J18N() {
    }

    private static synchronized void registerLocale(boolean allowNullPath, Locale locale, String path) {
        if (path == null && !allowNullPath) {
            throw new IllegalArgumentException("Null path");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Null locale");
        }
        if (TRANSLATION_MAP.containsKey(locale)) {
            throw new IllegalStateException("Locale already registered: " + locale.toString());
        }
        if (path == null) {
            TRANSLATION_MAP.put(locale, null);
        } else {
            Properties translations = new Properties();
            try (InputStream is = J18N.class.getResourceAsStream(path);){
                if (is == null) {
                    throw new IllegalArgumentException("Path not found: " + path);
                }
                translations.load(is);
                TRANSLATION_MAP.put(locale, translations);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static synchronized void registerLocale(Locale locale, String path) {
        J18N.registerLocale(false, locale, path);
    }

    public static synchronized void registerLocale(String locale, String path) {
        J18N.registerLocale(Locale.forLanguageTag(locale), path);
    }

    public static synchronized Set<Locale> getRegisteredLocales() {
        return Collections.unmodifiableSet(TRANSLATION_MAP.keySet());
    }

    public static synchronized Locale getSystemLocale() {
        return Locale.getDefault();
    }

    public static synchronized boolean isRegistered(Locale locale) {
        return TRANSLATION_MAP.containsKey(locale);
    }

    public static synchronized boolean isRegistered(String locale) {
        return J18N.isRegistered(Locale.forLanguageTag(locale));
    }

    private static synchronized void notifyLocaleChange(Locale newLocale) {
        for (LocaleChangeListener listener : LISTENERS) {
            listener.onLocaleChange(newLocale);
        }
    }

    public static synchronized void setCurrentLocale(Locale locale) throws UnsupportedOperationException {
        if (!Objects.equals(currentLocale, locale)) {
            currentLocale = locale;
            currentTranslations = TRANSLATION_MAP.get(locale);
            J18N.notifyLocaleChange(locale);
        }
    }

    public static synchronized void setCurrentLocale(String locale) throws UnsupportedOperationException {
        J18N.setCurrentLocale(Locale.forLanguageTag(locale));
    }

    public static synchronized Locale getCurrentLocale() throws IllegalStateException {
        return currentLocale;
    }

    static void resetTests() {
        for (Map.Entry<Locale, Properties> entry : TRANSLATION_MAP.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().clear();
        }
        TRANSLATION_MAP.clear();
        LISTENERS.clear();
        currentLocale = null;
        currentTranslations = null;
    }

    public static synchronized void registerListener(LocaleChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!LISTENERS.contains(listener)) {
            LISTENERS.add(listener);
        }
    }

    public static synchronized void unregisterListener(LocaleChangeListener listener) {
        LISTENERS.remove(listener);
    }

    public static synchronized void clearListeners() {
        LISTENERS.clear();
    }

    private static synchronized String tr(String str) throws IllegalStateException {
        if (str.trim().isEmpty()) {
            return str;
        }
        if (currentLocale == null) {
            return str;
        }
        if (currentTranslations == null) {
            return str;
        }
        String translation = currentTranslations.getProperty(str);
        if (translation == null || translation.trim().isEmpty()) {
            return str;
        }
        return translation;
    }

    public static synchronized String tr(String str, Object ... args) throws IllegalStateException {
        str = J18N.tr(str);
        return args.length == 0 ? str : String.format(str, args);
    }

    public static interface LocaleChangeListener {
        public void onLocaleChange(Locale var1);
    }
}

