/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.recognizer;

import com.darkprograms.speech.recognizer.GSpeechResponseListener;
import com.darkprograms.speech.recognizer.GoogleResponse;
import com.darkprograms.speech.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.sourceforge.javaflacencoder.FLACFileWriter;

public class GSpeechDuplex {
    private static final long MIN = 10000000L;
    private static final long MAX = 900000009999999L;
    private static final String GOOGLE_DUPLEX_SPEECH_BASE = "https://www.google.com/speech-api/full-duplex/v1/";
    private List<GSpeechResponseListener> responseListeners = new ArrayList<GSpeechResponseListener>();
    private final String API_KEY;
    private String language = "auto";
    private static final int MAX_SIZE = 0x100000;
    private static final byte[] FINAL_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private AudioInputStream ais;

    public GSpeechDuplex(String API_KEY) {
        this.API_KEY = API_KEY;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void recognize(File flacFile, int sampleRate) throws IOException {
        this.recognize(this.mapFileIn(flacFile), sampleRate);
    }

    public void recognize(byte[] data, int sampleRate) {
        if (data.length >= 0x100000) {
            byte[][] dataArray;
            for (byte[] array : dataArray = this.chunkAudio(data)) {
                this.recognize(array, sampleRate);
            }
        }
        long PAIR = 10000000L + (long)(Math.random() * 9.0E14);
        String API_DOWN_URL = "https://www.google.com/speech-api/full-duplex/v1/down?maxresults=1&pair=" + PAIR;
        String API_UP_URL = "https://www.google.com/speech-api/full-duplex/v1/up?lang=" + this.language + "&lm=dictation&client=chromium&pair=" + PAIR + "&key=" + this.API_KEY;
        this.downChannel(API_DOWN_URL);
        this.upChannel(API_UP_URL, this.chunkAudio(data), sampleRate);
    }

    public void recognize(TargetDataLine tl, AudioFormat af) throws LineUnavailableException, InterruptedException {
        long PAIR = 10000000L + (long)(Math.random() * 9.0E14);
        String API_DOWN_URL = "https://www.google.com/speech-api/full-duplex/v1/down?maxresults=1&pair=" + PAIR;
        String API_UP_URL = "https://www.google.com/speech-api/full-duplex/v1/up?lang=" + this.language + "&lm=dictation&client=chromium&pair=" + PAIR + "&key=" + this.API_KEY + "&continuous=true&interim=true";
        Thread downChannel = this.downChannel(API_DOWN_URL);
        Thread upChannel = this.upChannel(API_UP_URL, tl, af);
        try {
            downChannel.join();
            upChannel.interrupt();
            upChannel.join();
        }
        catch (InterruptedException e) {
            downChannel.interrupt();
            downChannel.join();
            upChannel.interrupt();
            upChannel.join();
        }
    }

    private Thread downChannel(String urlStr) {
        final String url = urlStr;
        Thread downChannelThread = new Thread("Downstream Thread"){

            public void run() {
                String response;
                Scanner inStream = GSpeechDuplex.this.openHttpsConnection(url);
                if (inStream == null) {
                    System.out.println("Error has occured");
                    return;
                }
                while (inStream.hasNext() && (response = inStream.nextLine()) != null) {
                    if (response.length() <= 17) continue;
                    GoogleResponse gr = new GoogleResponse();
                    GSpeechDuplex.this.parseResponse(response, gr);
                    GSpeechDuplex.this.fireResponseEvent(gr);
                }
                inStream.close();
                System.out.println("Finished write on down stream...");
            }
        };
        downChannelThread.start();
        return downChannelThread;
    }

    private void upChannel(String urlStr, byte[][] data, int sampleRate) {
        final String murl = urlStr;
        final byte[][] mdata = data;
        final int mSampleRate = sampleRate;
        new Thread("Upstream File Thread"){

            public void run() {
                GSpeechDuplex.this.openHttpsPostConnection(murl, mdata, mSampleRate);
            }
        }.start();
    }

    private Thread upChannel(String urlStr, TargetDataLine tl, AudioFormat af) throws LineUnavailableException {
        final String murl = urlStr;
        final TargetDataLine mtl = tl;
        final AudioFormat maf = af;
        if (!mtl.isOpen()) {
            mtl.open(maf);
            mtl.start();
        }
        Thread upChannelThread = new Thread("Upstream Thread"){

            public void run() {
                GSpeechDuplex.this.openHttpsPostConnection(murl, mtl, (int)maf.getSampleRate());
            }
        };
        upChannelThread.start();
        return upChannelThread;
    }

    private Scanner openHttpsConnection(String urlStr) {
        int resCode = -1;
        try {
            URL url = new URL(urlStr);
            URLConnection urlConn = url.openConnection();
            if (!(urlConn instanceof HttpsURLConnection)) {
                throw new IOException("URL is not an Https URL");
            }
            HttpsURLConnection httpConn = (HttpsURLConnection)urlConn;
            httpConn.setAllowUserInteraction(false);
            httpConn.setInstanceFollowRedirects(true);
            httpConn.setRequestMethod("GET");
            httpConn.connect();
            resCode = httpConn.getResponseCode();
            if (resCode == 200) {
                return new Scanner(httpConn.getInputStream(), "UTF-8");
            }
            System.out.println("Error: " + resCode);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void openHttpsPostConnection(String murl, TargetDataLine mtl, int sampleRate) {
        try {
            URL url = new URL(murl);
            HttpsURLConnection httpConn = this.getHttpsURLConnection(sampleRate, url);
            OutputStream out = httpConn.getOutputStream();
            System.out.println("Starting to write data to output...");
            this.ais = new AudioInputStream(mtl);
            AudioSystem.write(this.ais, FLACFileWriter.FLAC, out);
            System.out.println("Upstream Closed...");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void stopSpeechRecognition() {
        if (this.ais != null) {
            try {
                this.ais.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Scanner openHttpsPostConnection(String urlStr, byte[][] data, int sampleRate) {
        byte[][] mextrad = data;
        int resCode = -1;
        OutputStream out = null;
        try {
            URL url = new URL(urlStr);
            HttpsURLConnection httpConn = this.getHttpsURLConnection(sampleRate, url);
            out = httpConn.getOutputStream();
            System.out.println("Starting to write");
            for (byte[] dataArray : mextrad) {
                out.write(dataArray);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            out.write(FINAL_CHUNK);
            System.out.println("IO WRITE DONE");
            resCode = httpConn.getResponseCode();
            if (resCode / 100 != 2) {
                System.out.println("ERROR");
            }
            if (resCode == 200) {
                return new Scanner(httpConn.getInputStream(), "UTF-8");
            }
            System.out.println("HELP: " + resCode);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HttpsURLConnection getHttpsURLConnection(int sampleRate, URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (!(urlConn instanceof HttpsURLConnection)) {
            throw new IOException("URL is not an Https URL");
        }
        HttpsURLConnection httpConn = (HttpsURLConnection)urlConn;
        httpConn.setAllowUserInteraction(false);
        httpConn.setInstanceFollowRedirects(true);
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setChunkedStreamingMode(0);
        httpConn.setRequestProperty("Transfer-Encoding", "chunked");
        httpConn.setRequestProperty("Content-Type", "audio/x-flac; rate=" + sampleRate);
        httpConn.connect();
        return httpConn;
    }

    private byte[] mapFileIn(File infile) throws IOException {
        return Files.readAllBytes(infile.toPath());
    }

    private void parseResponse(String rawResponse, GoogleResponse gr) {
        if (rawResponse == null || !rawResponse.contains("\"result\"") || rawResponse.equals("{\"result\":[]}")) {
            return;
        }
        gr.getOtherPossibleResponses().clear();
        if (rawResponse.contains("\"confidence\":")) {
            String confidence = StringUtil.substringBetween(rawResponse, "\"confidence\":", "}");
            gr.setConfidence(confidence);
        } else {
            gr.setConfidence(String.valueOf(1));
        }
        String response = StringUtil.substringBetween(rawResponse, "[{\"transcript\":\"", "\"}],");
        if (response == null) {
            response = StringUtil.substringBetween(rawResponse, "[{\"transcript\":\"", "\",\"");
        }
        gr.setResponse(response);
        gr.setFinalResponse(rawResponse.contains("\"final\":true"));
        String[] currentHypos = rawResponse.split("\\[\\{\"transcript\":\"");
        for (int i = 2; i < currentHypos.length; ++i) {
            String cleaned = currentHypos[i].substring(0, currentHypos[i].indexOf(34));
            gr.getOtherPossibleResponses().add(cleaned);
        }
    }

    public synchronized void addResponseListener(GSpeechResponseListener rl) {
        this.responseListeners.add(rl);
    }

    public synchronized void removeResponseListener(GSpeechResponseListener rl) {
        this.responseListeners.remove(rl);
    }

    private synchronized void fireResponseEvent(GoogleResponse gr) {
        for (GSpeechResponseListener gl : this.responseListeners) {
            gl.onResponse(gr);
        }
    }

    private byte[][] chunkAudio(byte[] data) {
        if (data.length >= 0x100000) {
            int frame = 524288;
            int numOfChunks = (int)((double)data.length / (double)frame) + 1;
            byte[][] data2D = new byte[numOfChunks][];
            int i = 0;
            for (int j = 0; i < data.length && j < data2D.length; i += frame, ++j) {
                int length = data.length - i < frame ? data.length - i : frame;
                data2D[j] = new byte[length];
                System.arraycopy(data, i, data2D[j], 0, length);
            }
            return data2D;
        }
        byte[][] tmpData = new byte[1][data.length];
        System.arraycopy(data, 0, tmpData[0], 0, data.length);
        return tmpData;
    }
}

