/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.EncodedElement;

public class BlockEncodeRequest {
    volatile int[] samples;
    volatile int count;
    volatile int start;
    volatile int skip;
    volatile long frameNumber;
    volatile EncodedElement result;
    volatile boolean valid;
    volatile int encodedSamples;

    public void setAll(int[] samples, int count, int start, int skip, long frameNumber, EncodedElement result) {
        this.samples = samples;
        this.count = count;
        this.start = start;
        this.skip = skip;
        this.frameNumber = frameNumber;
        this.result = result;
        this.valid = false;
        this.encodedSamples = 0;
    }

    public int addInterleavedSamples(int[] newSamples, int offset, int addCount, int max) {
        assert (max <= this.samples.length / (this.skip + 1));
        if (max > this.samples.length) {
            max = this.samples.length / (this.skip + 1);
        }
        int remaining = this.count;
        int spaceLeft = max - this.count;
        int toEncode = addCount < spaceLeft ? addCount : spaceLeft;
        remaining = addCount - toEncode;
        int[] src = newSamples;
        int[] dest = this.samples;
        int destPos = this.count * (this.skip + 1);
        int srcPos = offset;
        int length = toEncode * (this.skip + 1);
        System.arraycopy(src, srcPos, dest, destPos, length);
        this.count += toEncode;
        return remaining;
    }

    public boolean isFull(int max) {
        boolean full = false;
        if (this.count >= max) {
            full = true;
        }
        return full;
    }
}

