/*
 * Decompiled with CFR 0.152.
 */
package vespague.automation;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Observable;
import java.util.Observer;
import lib.VBI;
import lib.comm.VeSComm;
import lib.file.VBIFile;
import lib.type.VeSException;
import lib.type.VeSInteger;
import vespague.automation.VSPagueClientAutomationInteractionBackground;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.client.InstanceCallback;
import vespague.client.VSPagueClientMainInstance;
import vespague.client.configuration.encryption.Configuration;
import vespague.client.configuration.encryption.ConfigurationEncryption;
import vespague.client.graphic.transacao.cartao.VSPagueCampoRoteamento;
import vespague.client.interaction.StatusUpdate;
import vespague.client.interaction.VeSPagueClientTransactionManager;
import vespague.common.VeSPagueClientUtil;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.VSPagueClientException;
import vespague.exception.VeSPagueClientException;
import vespague.structure.VeSPagueActivate;
import vespague.structure.VeSPagueParametroInfo;
import vespague.structure.VeSPagueTransacao;

public class VSPagueClientAutomationInteractionDriver
extends VSPagueClientAutomationInteractionBackground
implements Observer {
    private VeSComm socket;
    private static final int SERVICE_TIMEOUT = 15000;
    private boolean ib_servico_iniciar_sucesso;
    private boolean ib_observer_disabled;

    public VSPagueClientAutomationInteractionDriver(VeSPagueClientTransactionManager ao_transaction_manager, VeSComm ao_comm, InstanceCallback callback) throws Exception {
        super(ao_transaction_manager, ao_comm, callback);
        this.socket = ao_comm;
    }

    boolean threadReceiveAlive() {
        return super.threadReceiveAlive() && this.socket != null && this.socket.Connected();
    }

    protected void ServicoIniciar(VeSPagueClientToAutomation ao_automation) throws VeSException {
        this.ServidorConectar(ao_automation);
        super.ServicoIniciar(ao_automation);
        this.ib_servico_iniciar_sucesso = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void ServidorConectar(VeSPagueClientToAutomation ao_automation) throws VeSException {
        boolean terminalConsistido;
        boolean executaServicoIdentificar;
        block18: {
            if (this.TransactionManagerGet().io_client_to_server.Connected()) return;
            if (ao_automation.computador_nome == null || ao_automation.computador_endereco == null) throw new VSPagueClientException(VeSPagueMessageOld.MessageGet((int)117));
            try {
                this.TentativasConectar();
            }
            finally {
                if (!this.TransactionManagerGet().io_client_to_server.Connected()) {
                    this.io_thd_receive.Interrupt(null);
                }
            }
            executaServicoIdentificar = true;
            terminalConsistido = ao_automation.estabelecimento != null && ao_automation.loja != null && ao_automation.terminal != null;
            try {
                if (!terminalConsistido) break block18;
                this.TransactionManagerGet().io_client.setEstabelecimento(ao_automation.estabelecimento);
                this.TransactionManagerGet().io_client.setLoja(ao_automation.loja);
                this.TransactionManagerGet().io_client.setTerminal(ao_automation.terminal);
                try {
                    this.TransactionManagerGet().io_client_to_server.arquivosConfiguracaoCarregar();
                }
                catch (Exception e) {
                    LOGGER.info("Erro ao carregar configuracao", (Throwable)e);
                }
                if (this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet() != null) {
                    ConfigurationEncryption.init();
                    ConfigurationEncryption configurationEncryption = ConfigurationEncryption.getInstance();
                    if (configurationEncryption.getConfiguration().isPresent()) {
                        Configuration configuration = (Configuration)configurationEncryption.getConfiguration().get();
                        this.TransactionManagerGet().io_client.configureWorkingKeys((byte[])configuration.getWorkingKey().get(), (byte[])configuration.getPinDesWorkingKey().get(), (byte[])configuration.getWorkingKey().get(), (byte[])configuration.getWorkingKeyCrypt().get());
                    }
                    boolean isMelhorTaxa = this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet().ib_rede_menor_taxa != null && this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet().ib_rede_menor_taxa != false;
                    executaServicoIdentificar = ao_automation.estabelecimento == null && ao_automation.loja == null && ao_automation.terminal == null || !configurationEncryption.getConfiguration().isPresent() || isMelhorTaxa && !VSPagueCampoRoteamento.isRoteamentoConfigurado();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("nao foi possivel carregar as configuracoes do disco", (Throwable)ex);
            }
        }
        this.TransactionManagerGet().io_client_to_server.ConnectionIdentifierDriverSet(String.valueOf(ao_automation.aplicacao) + " " + ao_automation.versao, ao_automation.computador_nome.toLowerCase(), new String[]{ao_automation.computador_endereco.toUpperCase()}, null, null, null, null, ao_automation.transacao_cnpj_cpf);
        try {
            if (executaServicoIdentificar) {
                this.ServicoIdentificarEnviar(ao_automation);
            } else {
                try {
                    if (this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet() == null) {
                        this.TransactionManagerGet().io_client_to_server.loadConfiguracaoData();
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (!terminalConsistido) return;
            Object activate = this.TransactionManagerGet().io_client_to_server.isAtivacaoProcessar() ? this.ServicoAtivarEnviar() : this.TransactionManagerGet().io_client_to_server.getActivate();
            this.setServicoAtivar(activate);
            this.GerenciadorTransacaoIniciar();
            return;
        }
        catch (Exception ex) {
            throw new VeSPagueClientException((Throwable)ex);
        }
    }

    private final void TentativasConectar() throws VeSPagueClientException {
        try {
            int ln_tentativas_conectar = 1;
            boolean lb_connected = false;
            do {
                try {
                    try {
                        if (ln_tentativas_conectar > 1) {
                            LOGGER.error(String.valueOf(ln_tentativas_conectar) + "\u00aa tentativa de conex\u00e3o com o servidor...");
                        }
                        try {
                            this.TransactionManagerGet().io_client_to_server.Stop();
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                        this.TransactionManagerGet().io_client_to_server.Start(this.TransactionManagerGet());
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Falha ao conectar no servidor na " + ln_tentativas_conectar + "\u00aa tentativa", ex);
                        try {
                            this.TransactionManagerGet().io_client_to_server.Stop();
                            LOGGER.error("Desconectado do V$PagueServer");
                        }
                        catch (Throwable ex1) {
                            VBI.Trace((String)"Erro no Stop");
                            ex1.printStackTrace();
                        }
                        if (ln_tentativas_conectar == 4) {
                            throw ex;
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Throwable ex1) {
                            VBI.Trace((String)"Erro no sleep(2000)");
                            ex1.printStackTrace();
                        }
                        ++ln_tentativas_conectar;
                        try {
                            lb_connected = this.TransactionManagerGet().io_client_to_server.Connected();
                        }
                        catch (Throwable ex2) {
                            lb_connected = false;
                            VBI.Trace((String)"Erro no Connected");
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        lb_connected = this.TransactionManagerGet().io_client_to_server.Connected();
                    }
                    catch (Throwable ex) {
                        lb_connected = false;
                        VBI.Trace((String)"Erro no Connected");
                    }
                    throw throwable;
                }
                try {
                    lb_connected = this.TransactionManagerGet().io_client_to_server.Connected();
                }
                catch (Throwable ex) {
                    lb_connected = false;
                    VBI.Trace((String)"Erro no Connected");
                }
            } while (ln_tentativas_conectar <= 4 && !lb_connected);
        }
        catch (Exception ex) {
            throw new VeSPagueClientException(VeSPagueMessageOld.MessageGet((int)116));
        }
    }

    private final void ServicoIdentificarEnviar(VeSPagueClientToAutomation ao_automation) throws Exception {
        String[] ls_identify = null;
        try {
            ls_identify = this.TransactionManagerGet().io_client_to_server.ServicoIdentificarEnviar(15000);
        }
        catch (VBIFile.VBIFileInputOutputException ex) {
            VBI.Trace((String)("Deletando o arquivo " + this.TransactionManagerGet().io_client.NomeArquivoConfiguracaoCriar() + " para solicitar um novo: " + VeSException.MessageGet((Throwable)ex)));
            VBIFile.FileDelete((String)this.TransactionManagerGet().io_client.NomeArquivoConfiguracaoCriar());
        }
        if (ao_automation.transacao_cnpj_cpf != null) {
            ao_automation.estabelecimento = this.TransactionManagerGet().io_client.getEstabelecimento();
            ao_automation.loja = this.TransactionManagerGet().io_client.getLoja();
            ao_automation.terminal = this.TransactionManagerGet().io_client.getTerminal();
            if (ls_identify != null) {
                String[] stringArray;
                String ls_complemento;
                int ln_1 = 0;
                while (ln_1 < ls_identify.length) {
                    ls_identify[ln_1] = ls_identify[ln_1].replaceAll(";", "").replaceAll("  ", " ");
                    ++ln_1;
                }
                String ls_nome_fantasia = !ls_identify[10].isEmpty() ? ls_identify[10] : null;
                String ls_endereco = !ls_identify[11].isEmpty() ? ls_identify[11] : null;
                String ls_numero = !ls_identify[12].isEmpty() ? ls_identify[12] : null;
                String ls_cep = !ls_identify[13].isEmpty() ? ls_identify[13] : null;
                String ls_bairro = !ls_identify[14].isEmpty() ? ls_identify[14] : null;
                String ls_cidade = !ls_identify[15].isEmpty() ? ls_identify[15] : null;
                String ls_estado = !ls_identify[16].isEmpty() ? ls_identify[16] : null;
                String ls_pais = !ls_identify[17].isEmpty() ? ls_identify[17] : null;
                String ls_fone = !ls_identify[18].isEmpty() ? ls_identify[18] : null;
                String ls_email = !ls_identify[19].isEmpty() ? ls_identify[19] : null;
                String ls_site = !ls_identify[20].isEmpty() ? ls_identify[20] : null;
                String string = ls_complemento = !ls_identify[21].isEmpty() ? ls_identify[21] : null;
                if (!ls_identify[22].isEmpty()) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ls_identify[22];
                } else {
                    stringArray = null;
                }
                ao_automation.mensagem = stringArray;
                ao_automation.transacao_opcao = new String[]{ls_nome_fantasia, ls_endereco, ls_numero, ls_cep, ls_bairro, ls_cidade, ls_estado, ls_pais, ls_fone, ls_email, ls_site, ls_complemento};
            }
        } else {
            if (ao_automation.estabelecimento == null || ao_automation.loja == null || ao_automation.terminal == null) {
                throw new VeSPagueClientException(VeSPagueMessageOld.MessageGet((int)117));
            }
            if (!(this.TransactionManagerGet().io_client.getEstabelecimento().equals(ao_automation.estabelecimento) && this.TransactionManagerGet().io_client.getLoja().equals(ao_automation.loja) && this.TransactionManagerGet().io_client.getTerminal().equals(ao_automation.terminal))) {
                VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)126);
                String ls_message = lo_message.toString(new Object[]{String.valueOf(ao_automation.estabelecimento) + '\\' + ao_automation.loja + '\\' + ao_automation.terminal});
                throw new VeSPagueClientException(ls_message, lo_message.CodeGet());
            }
        }
        VSPagueClientMainInstance.setDefaultLayoutConf((Integer)this.TransactionManagerGet().io_client_to_server.ParameterInformationGet().getLayout());
        this.TransactionManagerGet().io_client_to_server.ConnectionIdentifierDriverSet(String.valueOf(ao_automation.aplicacao) + " " + ao_automation.versao, ao_automation.computador_nome.toLowerCase(), new String[]{ao_automation.computador_endereco.toUpperCase()}, null, ao_automation.estabelecimento, ao_automation.loja, ao_automation.terminal, ao_automation.transacao_cnpj_cpf);
    }

    private Object ServicoAtivarEnviar() throws Exception {
        VeSPagueParametroInfo lo_parametro = this.TransactionManagerGet().io_client_to_server.ParameterInformationGet();
        lo_parametro.is_parametro_versao = this.TransactionManagerGet().DatastoreGet() != null ? this.TransactionManagerGet().DatastoreGet().ParametroVersionGet() : null;
        Object lo_activate = this.TransactionManagerGet().io_client_to_server.SendReceive(VeSPagueClientUtil.SERVICE_ACTIVE, (Serializable)lo_parametro, 60000);
        this.TransactionManagerGet().io_client_to_server.getStatusUpdateControler().statusUpdate(StatusUpdate.NONE);
        return lo_activate;
    }

    private void setServicoAtivar(Object lo_activate) throws VeSPagueClientException {
        if (lo_activate instanceof VeSPagueActivate) {
            this.TransactionManagerGet().io_client_to_server.ServicoAtivarProcessar(lo_activate);
        } else {
            VBI.Trace((String)("Recebido " + lo_activate + " na ativa\u00e7\u00e3o ao inv\u00e9s de um VeSPagueActivate. Pr\u00f3ximo passo \u00e9 configurar a aplica\u00e7\u00e3o comercial..."));
        }
        this.TransactionManagerGet().io_client_to_server.AutomacaoConfigurar(this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet().is_cfg_comunicacao, this.TransactionManagerGet().io_client_to_server.ConfiguracaoDataGet().io_cfg_terminal.XmlComunicacaoGet());
    }

    private final void GerenciadorTransacaoIniciar() throws VeSPagueClientException {
        this.TransactionManagerGet().io_client.in_mode = 3;
        this.TransactionManagerGet().Start();
    }

    protected void ServicoExecutar(VeSPagueClientToAutomation ao_automation) throws VeSPagueClientException {
        if (!this.ib_servico_iniciar_sucesso) {
            this.io_thd_receive.Interrupt(null);
            throw new VeSPagueClientException(VeSPagueMessageOld.MessageGet((int)124));
        }
        super.ServicoExecutar(ao_automation);
    }

    protected void ServicoFinalizar(VeSPagueClientToAutomation ao_automation) throws Exception {
        this.ib_servico_iniciar_sucesso = false;
        super.ServicoFinalizar(ao_automation);
        this.io_thd_receive.Interrupt(null);
    }

    protected void PinpadClose() {
        this.ib_observer_disabled = true;
    }

    @Override
    public void update(Observable ao_observable, Object ao_object) {
        if (!this.ib_observer_disabled) {
            VeSPagueClientToAutomation veSPagueClientToAutomation = new VeSPagueClientToAutomation();
            veSPagueClientToAutomation.automacao_coleta_sequencial = new VeSInteger((long)(++this.in_sequencial_incrementar));
            veSPagueClientToAutomation.automacao_coleta_retorno = VeSInteger.ONE;
            veSPagueClientToAutomation.automacao_coleta_mensagem = new String[]{((String)ao_object).trim().replaceAll("\"", "").replaceAll("\r\n", " ").replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("( )+", " ").trim().toUpperCase()};
            try {
                this.ib_responder_aplicacao_comercial = true;
                this.Send(veSPagueClientToAutomation.toString());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected boolean SequencialMenorVerificar(VeSPagueClientToAutomation ao_automation) {
        return this.in_sequencial_ultimo != null && ao_automation.sequencial != null && ao_automation.sequencial.compareTo((BigInteger)this.in_sequencial_ultimo) <= 0 && (this.io_transaction_receive = (VeSPagueTransacao)this.io_transaction_pendente.get(ao_automation.sequencial)) == null;
    }
}

