/*
 * Decompiled with CFR 0.152.
 */
package vespague.automation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lib.type.VBIDatetime;
import lib.type.VeSDecimal;
import lib.type.VeSInteger;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.automation.VeSPagueClientToAutomationParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class VeSPagueClientToAutomationParser {
    private static final Set<String> PREFIXOS_REMOVER = new HashSet<String>(Arrays.asList("transacao_", "automacao_"));
    private static final Map<String, MascaramentoConfig> REGRAS_MASCARAMENTO = new HashMap();
    private static final Map<String, MascaramentoConfig> REGRAS_MASCARAMENTO_COLETA = new HashMap();

    static {
        REGRAS_MASCARAMENTO.put("transacao_cartao_numero", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("cartao_numero", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("cartao_codigo_seguranca", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("transacao_cartao_codigo_seguranca", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("cartao_validade", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("transacao_cartao_validade", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("transacao_administracao_usuario", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO.put("transacao_administracao_senha", new MascaramentoConfig("automacao_coleta_informacao", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("transacao_cartao_numero", new MascaramentoConfig("transacao_cartao_numero", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("cartao_numero", new MascaramentoConfig("cartao_numero", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("cartao_codigo_seguranca", new MascaramentoConfig("cartao_codigo_seguranca", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("transacao_cartao_codigo_seguranca", new MascaramentoConfig("transacao_cartao_codigo_seguranca", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("cartao_validade", new MascaramentoConfig("cartao_validade", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("transacao_cartao_validade", new MascaramentoConfig("transacao_cartao_validade", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("transacao_administracao_usuario", new MascaramentoConfig("transacao_administracao_usuario", '*'));
        REGRAS_MASCARAMENTO_COLETA.put("transacao_administracao_senha", new MascaramentoConfig("transacao_administracao_senha", '*'));
    }

    public static StringBuilder parse(VeSPagueClientToAutomation objeto) {
        StringBuilder resultado = new StringBuilder();
        if (objeto == null) {
            return resultado;
        }
        Field[] campos = objeto.getClass().getDeclaredFields();
        boolean primeiro = true;
        Field[] fieldArray = campos;
        int n = campos.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Field campo = fieldArray[n2];
                try {
                    if (Modifier.isStatic(campo.getModifiers())) break block11;
                    campo.setAccessible(true);
                    Object valor = campo.get(objeto);
                    if (valor == null) break block11;
                    String palavraChave = objeto.automacao_coleta_palavra_chave;
                    MascaramentoConfig configMascaramento = null;
                    if (palavraChave != null && REGRAS_MASCARAMENTO.containsKey(palavraChave)) {
                        configMascaramento = (MascaramentoConfig)REGRAS_MASCARAMENTO.get(palavraChave);
                    }
                    if (valor.getClass().isArray()) {
                        if (Array.getLength((Object)valor) == 0) break block11;
                        boolean temConteudo = false;
                        int i = 0;
                        while (i < Array.getLength((Object)valor)) {
                            if (Array.get((Object)valor, (int)i) != null) {
                                temConteudo = true;
                                break;
                            }
                            ++i;
                        }
                        if (!temConteudo) break block11;
                    }
                    String nomeTag = VeSPagueClientToAutomationParser.formatarNomeTag((String)campo.getName());
                    if (configMascaramento == null && REGRAS_MASCARAMENTO_COLETA.containsKey(campo.getName())) {
                        configMascaramento = (MascaramentoConfig)REGRAS_MASCARAMENTO_COLETA.get(campo.getName());
                    }
                    String valorFormatado = configMascaramento != null && campo.getName().equals(configMascaramento.campoParaMascarar) ? VeSPagueClientToAutomationParser.aplicarMascaramento((String)VeSPagueClientToAutomationParser.formatarValor((Object)valor), (MascaramentoConfig)configMascaramento) : VeSPagueClientToAutomationParser.formatarValor((Object)valor);
                    if (!primeiro) {
                        resultado.append(", ");
                    }
                    resultado.append(nomeTag).append(":").append(valorFormatado);
                    primeiro = false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return resultado;
    }

    private static String aplicarMascaramento(String valor, MascaramentoConfig config) {
        if (valor == null || valor.isEmpty()) {
            return valor;
        }
        try {
            String numeroLimpo = valor.replaceAll("[^0-9]", "");
            return VeSPagueClientToAutomationParser.mascararTodosCaracteres((String)numeroLimpo, (char)config.caractereMascara);
        }
        catch (Exception e) {
            return VeSPagueClientToAutomationParser.mascaramentoSimples((String)valor, (char)config.caractereMascara);
        }
    }

    private static String mascararTodosCaracteres(String valor, char caractereMascara) {
        if (valor == null || valor.isEmpty()) {
            return valor;
        }
        StringBuilder resultado = new StringBuilder();
        int i = 0;
        while (i < valor.length()) {
            resultado.append(caractereMascara);
            ++i;
        }
        return resultado.toString();
    }

    private static String mascaramentoSimples(String valor, char caractereMascara) {
        if (valor == null || valor.length() <= 4) {
            return valor;
        }
        StringBuilder resultado = new StringBuilder();
        int i = 0;
        while (i < valor.length()) {
            if (i < 4 || i >= valor.length() - 4) {
                resultado.append(valor.charAt(i));
            } else {
                resultado.append(caractereMascara);
            }
            ++i;
        }
        return resultado.toString();
    }

    private static String formatarNomeTag(String nomeOriginal) {
        String nome = nomeOriginal;
        for (String prefixo : PREFIXOS_REMOVER) {
            if (!nome.startsWith(prefixo)) continue;
            nome = nome.substring(prefixo.length());
            break;
        }
        StringBuilder resultado = new StringBuilder();
        boolean proximaMaiuscula = false;
        int i = 0;
        while (i < nome.length()) {
            char caractere = nome.charAt(i);
            if (caractere == '_') {
                proximaMaiuscula = true;
            } else if (proximaMaiuscula && Character.isLowerCase(caractere)) {
                resultado.append(Character.toUpperCase(caractere));
                proximaMaiuscula = false;
            } else {
                resultado.append(caractere);
                proximaMaiuscula = false;
            }
            ++i;
        }
        return resultado.toString();
    }

    private static String formatarValor(Object valor) {
        if (valor == null) {
            return "";
        }
        if (valor.getClass().isArray()) {
            StringBuilder arrayStr = new StringBuilder();
            arrayStr.append("[");
            int length = Array.getLength((Object)valor);
            int i = 0;
            while (i < length) {
                Object elemento = Array.get((Object)valor, (int)i);
                if (elemento != null) {
                    if (i > 0) {
                        arrayStr.append(", ");
                    }
                    arrayStr.append(VeSPagueClientToAutomationParser.formatarValor((Object)elemento));
                }
                ++i;
            }
            arrayStr.append("]");
            return arrayStr.toString();
        }
        if (valor instanceof VBIDatetime) {
            return ((VBIDatetime)valor).toString();
        }
        if (valor instanceof VeSInteger) {
            return ((VeSInteger)valor).toString();
        }
        if (valor instanceof VeSDecimal) {
            return ((VeSDecimal)valor).toString();
        }
        return valor.toString();
    }

    public static void removerRegraMascaramento(String palavraChave) {
        REGRAS_MASCARAMENTO.remove(palavraChave);
    }
}

