/*
 * Decompiled with CFR 0.152.
 */
package vespague.automation.web;

import java.util.Date;
import java.util.Objects;
import lib.type.VeSInteger;
import org.json.JSONException;
import org.json.JSONObject;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.automation.web.JsonUtils;

public class WebJsonProtocol {
    private static boolean jsonSupported = false;

    public static boolean jsonSupported() {
        return jsonSupported;
    }

    public static boolean isJsonValid(String buffer) {
        try {
            new JSONObject(buffer);
            jsonSupported = true;
        }
        catch (JSONException e) {
            jsonSupported = false;
        }
        return jsonSupported;
    }

    public static String toJson(VeSPagueClientToAutomation automation) {
        return JsonUtils.toJson((VeSPagueClientToAutomation)automation);
    }

    public static VeSPagueClientToAutomation fromJson(String json) {
        VeSPagueClientToAutomation automation = JsonUtils.fromJson((String)json);
        if (Objects.nonNull(automation.servico)) {
            if (Objects.equals(automation.servico, "confirmar")) {
                automation.retorno = new VeSInteger(0L);
                automation.servico = "executar";
            } else if (Objects.equals(automation.servico, "desfazer")) {
                automation.retorno = new VeSInteger(9L);
                automation.servico = "executar";
            } else {
                automation.retorno = new VeSInteger(1L);
            }
        }
        if ((Objects.isNull(automation.retorno) || Objects.equals(automation.retorno, VeSInteger.ONE)) && Objects.isNull(automation.sequencial)) {
            automation.sequencial = new VeSInteger(new Date().getTime());
        }
        return automation;
    }
}

