/*
 * Decompiled with CFR 0.152.
 */
package vespague.client;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import lib.VBIMain;
import lib.VeSUtil;
import lib.console.VBIConsole;
import lib.file.VBIFile;
import lib.file.VBIFileJar;
import lib.type.VeSDecimal;
import lib.xml.VBIXmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.VSPagueClientCommandLine;
import vespague.exception.VeSPagueClientException;

public class VSPagueClientMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueClientMain.class);
    private static final String CERTIFICATE_PATH = "VSPague.jks";
    private static final String CERTIFICATE_PASS = "VSPagueNexu";
    static String[] ARGUMENTS;
    private final VSPagueClientCommandLine io_command_line;
    private final ServerSocket io_server;
    private final String NAME_DRIVER_INSTANCE_POOL_THREADS = "DRIVER_INSTANCE_POOL_THREADS";
    private final String poolThreadsMinMaxValue;
    private final ThreadPoolExecutor threadPoolExecutor;
    private static int timeListenClose;

    public VSPagueClientMain(VSPagueClientCommandLine ao_command_line, int an_port_listen) throws IOException, VBIXmlException, VeSPagueClientException, VBIFileJar.VBIFileJarEntryNotFoundException, VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException, VBIConsole.VBIConsoleException {
        if (!ao_command_line.ArgumentExists(ao_command_line.ServerHostArgumentGet()) || !ao_command_line.ArgumentExists(ao_command_line.ServerDefaultPortArgumentGet())) {
            throw new VeSPagueClientException("Argumentos obrigat\u00f3rios n\u00e3o recebidos: " + ao_command_line.ServerHostArgumentGet() + ", " + ao_command_line.ServerDefaultPortArgumentGet() + " e " + ao_command_line.MerchantApplicationPortArgumentGet());
        }
        this.io_command_line = ao_command_line;
        ARGUMENTS = ao_command_line.ArgumentsGet();
        int ln_port = an_port_listen;
        int ln_backlog = 500;
        if (!this.io_command_line.ArgumentExists(this.io_command_line.Tls())) {
            this.CertificadoExportarEConfigurar();
            this.io_server = SSLServerSocketFactory.getDefault().createServerSocket(ln_port, ln_backlog);
        } else {
            this.io_server = ServerSocketFactory.getDefault().createServerSocket(ln_port, ln_backlog);
        }
        String poolThreadsMinMax = System.getenv("DRIVER_INSTANCE_POOL_THREADS");
        if (poolThreadsMinMax != null) {
            String[] values = poolThreadsMinMax.split(",");
            if (values.length != 2) {
                throw new VeSPagueClientException("Parametros invalidos para o pool de threads (DRIVER_INSTANCE_POOL_THREADS): " + poolThreadsMinMax);
            }
            this.poolThreadsMinMaxValue = poolThreadsMinMax.replaceAll(" ", "");
            LOGGER.info("Ajustados os parametros para o pool de threads ({}): {}", (Object)"DRIVER_INSTANCE_POOL_THREADS", (Object)this.poolThreadsMinMaxValue);
        } else {
            this.poolThreadsMinMaxValue = "5,20";
        }
        String[] minMaxValue = this.poolThreadsMinMaxValue.split(",");
        this.threadPoolExecutor = new ThreadPoolExecutor(Integer.valueOf(minMaxValue[0].trim()), Integer.valueOf(minMaxValue[1].trim()), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private final void CertificadoExportarEConfigurar() throws VBIFileJar.VBIFileJarEntryNotFoundException, VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        VBIFileJar lo_jar_vspagueclient = VBIMain.ApplicationJarfileGet();
        if (lo_jar_vspagueclient != null) {
            lo_jar_vspagueclient.FileExtract("VBI/security/lib/zi/VSPague.jks");
        }
        System.setProperty("javax.net.ssl.keyStore", CERTIFICATE_PATH);
        System.setProperty("javax.net.ssl.keyStorePassword", CERTIFICATE_PASS);
        System.setProperty("https.protocols", "TLSv1.2");
    }

    private final Thread ThreadListen(int an_count) {
        String name = String.valueOf(this.getClass().getSimpleName()) + ".Listen." + this.io_server.getLocalPort() + "." + an_count;
        return new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public final void Start() {
        int ln = 0;
        while (ln < 5) {
            this.ThreadListen(ln + 1).start();
            ++ln;
        }
    }

    private final String MemoriaVerificar() {
        VeSDecimal[] ln_memoria_livre = VeSUtil.MemoryJavaVerify();
        return "Mem\u00f3ria m\u00e1xima (XMX): " + ln_memoria_livre[0] + " Mb" + "\r\n" + "Mem\u00f3ria alocada: " + ln_memoria_livre[1] + " Mb" + "\r\n" + "Mem\u00f3ria usada: " + ln_memoria_livre[2] + " Mb" + "\r\n" + "Mem\u00f3ria livre: " + ln_memoria_livre[3].intValue() + "%";
    }

    public static void main(String[] as_arguments) throws Throwable {
        VSPagueClientCommandLine lo_command_line = new VSPagueClientCommandLine(as_arguments);
        VSPagueClientMain lo_main = new VSPagueClientMain(lo_command_line, 60906);
        lo_main.Start();
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    static /* synthetic */ ServerSocket access$1(VSPagueClientMain vSPagueClientMain) {
        return vSPagueClientMain.io_server;
    }

    static /* synthetic */ int access$2() {
        return timeListenClose;
    }

    static /* synthetic */ ThreadPoolExecutor access$3(VSPagueClientMain vSPagueClientMain) {
        return vSPagueClientMain.threadPoolExecutor;
    }
}

