/*
 * Decompiled with CFR 0.152.
 */
package vespague.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import lib.VeSUtil;
import lib.comm.VeSComm;
import lib.comm.structure.VeSCommSocketConfiguration;
import lib.type.VeSDecimal;
import lib.type.VeSException;
import lib.type.VeSInteger;
import lib.xml.VBIXmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.InstanceCallback;
import vespague.client.VSPagueClientCommandLine;
import vespague.client.VSPagueClientMain;
import vespague.client.VSPagueClientMainInstance;
import vespague.client.graphic.VSPagueClient;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.interaction.VSPagueClientToServerMain;

public class VSPagueClientMainInstance
implements Runnable,
InstanceCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueClientMainInstance.class);
    private final Socket socket;
    private static Integer requestCount = 0;
    private final String instanceId = "vspg-id-" + UUID.randomUUID().toString().substring(28);
    private static final int SIZE_HEADER = 4;
    private ByteBuffer byteBufferTemporary;
    public static final Map<String, VeSPagueClient> INSTANCES = new ConcurrentHashMap();
    private static int defaultLayoutConf;
    private static VeSCommSocketConfiguration CONFIGURATION_SOCKET;

    static {
        try {
            CONFIGURATION_SOCKET = new VeSCommSocketConfiguration();
            VSPagueClientMainInstance.CONFIGURATION_SOCKET.in_break_idle_time = 180;
        }
        catch (VBIXmlException ex) {
            throw new RuntimeException("Problema ao criar a configuracao padrao para instancias automaticas: " + VeSException.MessageGet((Throwable)ex));
        }
    }

    VSPagueClientMainInstance(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void run() {
        block9: {
            try {
                this.socket.setKeepAlive(true);
                this.socket.setTrafficClass(8);
                this.socket.setTcpNoDelay(true);
                this.socket.setReuseAddress(true);
                this.socket.setSoLinger(true, 0);
                this.socket.setSoTimeout(3000);
                if (this.socket instanceof SSLSocket) {
                    SSLSocket lo_socket_ssl = (SSLSocket)this.socket;
                    lo_socket_ssl.setEnabledProtocols(new String[]{"TLSv1.1", "TLSv1.2"});
                    lo_socket_ssl.startHandshake();
                }
                if (!this.connectionBreakedValidate(this.socket)) {
                    VeSDecimal[] ln_memory = VeSUtil.MemoryJavaVerify();
                    LOGGER.info("Memory/Request=" + ln_memory[1].intValue() * 1024 + "|" + ln_memory[2].intValue() * 1024 + "|" + ln_memory[3] + "%|" + requestCount);
                    VSCommSocket lo_comm = new VSCommSocket(this, this.socket, CONFIGURATION_SOCKET.clone());
                    lo_comm.Connect(null, 50);
                    VSPagueClientCommandLine lo_command_line = new VSPagueClientCommandLine(VSPagueClientMain.ARGUMENTS);
                    String[] ls_arguments = new String[]{lo_command_line.ServerHostArgumentGet(), lo_command_line.ValueGet(lo_command_line.ServerHostArgumentGet()), lo_command_line.ServerDefaultPortArgumentGet(), lo_command_line.ValueGet(lo_command_line.ServerDefaultPortArgumentGet()), lo_command_line.EstabelecimentoLojaTerminal()};
                    VSPagueClientCommandLine lo_command_instance = new VSPagueClientCommandLine(ls_arguments);
                    VSPagueClient lo_client = new VSPagueClient(this.instanceId, "V$PagueClient", lo_command_instance.ArgumentsGet(), lo_command_instance, VSPagueClientToServerMain.class);
                    VeSCommSocketConfiguration lo_cfg_instance = new VeSCommSocketConfiguration();
                    lo_cfg_instance.is_host = lo_command_line.ValueGet(lo_command_line.ServerHostArgumentGet());
                    lo_cfg_instance.in_port = new VeSInteger(lo_command_line.ValueGet(lo_command_line.ServerDefaultPortArgumentGet()));
                    lo_cfg_instance.in_mode = new VeSInteger(0L);
                    lo_cfg_instance.in_break_idle_time = VSPagueClientMainInstance.CONFIGURATION_SOCKET.in_break_idle_time;
                    lo_cfg_instance.in_reconnect_automatic_delay = null;
                    lo_cfg_instance.ib_secure_socket_layer = true;
                    lo_cfg_instance.ib_certificate_self_signed = !lo_command_line.ArgumentExists(lo_command_line.Tls());
                    lo_cfg_instance.ib_trace = lo_command_line.ArgumentExists(lo_command_instance.ServerTraceArgumentGet());
                    lo_cfg_instance.in_reconnect_wait_time = 10000L;
                    VeSPagueClient lo_instance = null;
                    try {
                        lo_instance = lo_client.AplicacaoInstanciar((VeSComm)lo_comm, lo_cfg_instance, (InstanceCallback)this);
                        break block9;
                    }
                    finally {
                        if (lo_instance != null) {
                            INSTANCES.put(this.instanceId, lo_instance);
                        }
                    }
                }
                this.disconnect(this.socket);
            }
            catch (SocketTimeoutException | SSLHandshakeException e) {
                this.disconnect(this.socket);
            }
            catch (Throwable e) {
                this.disconnect(this.socket);
                LOGGER.debug("Erro ao instanciar: {}", (Object)e.getMessage());
            }
        }
    }

    private void disconnect(Socket socket) {
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean connectionBreakedValidate(Socket socket) throws IOException {
        InputStream in = socket.getInputStream();
        boolean connectionBreaked = true;
        int sizeRead = 0;
        byte[] bytesLidos = new byte[4];
        try {
            sizeRead = in.read(bytesLidos);
            if (sizeRead > 0) {
                connectionBreaked = false;
                boolean isSize = this.isNumber(bytesLidos);
                if (!isSize) {
                    this.byteBufferTemporary = ByteBuffer.allocate(bytesLidos.length);
                    this.byteBufferTemporary.put(bytesLidos);
                    this.byteBufferTemporary.flip();
                }
            }
        }
        catch (SocketTimeoutException ex) {
            LOGGER.error("socket timeout exception");
        }
        catch (Exception ex) {
            LOGGER.error("erro", (Throwable)ex);
            throw ex;
        }
        return connectionBreaked;
    }

    private void cleanInstance() {
        block9: {
            VeSPagueClient lo_client = (VeSPagueClient)INSTANCES.remove(this.instanceId);
            LOGGER.info("INSTANCES {}", (Object)INSTANCES.size());
            LOGGER.info("lo_client {} {}", (Object)lo_client, (Object)this.instanceId);
            try {
                try {
                    if (lo_client != null) {
                        try {
                            lo_client.io_transaction_manager.Finalize();
                            break block9;
                        }
                        finally {
                            this.AllObjectsReflectionNull((Object)lo_client);
                        }
                    }
                    LOGGER.error("Instancia nao encontrada na lista: " + this.instanceId);
                }
                catch (Throwable ex) {
                    LOGGER.error(ex.getMessage(), ex);
                    VeSDecimal[] ln_memory = VeSUtil.MemoryJavaVerify();
                    LOGGER.info("Memory=" + ln_memory[1].intValue() * 1024 + "|" + ln_memory[2].intValue() * 1024 + "|" + ln_memory[3] + "%");
                }
            }
            finally {
                VeSDecimal[] ln_memory = VeSUtil.MemoryJavaVerify();
                LOGGER.info("Memory=" + ln_memory[1].intValue() * 1024 + "|" + ln_memory[2].intValue() * 1024 + "|" + ln_memory[3] + "%");
            }
        }
    }

    private final void AllObjectsReflectionNull(Object ao_object) {
        ArrayList<Field> lo_lst_fields = new ArrayList<Field>();
        lo_lst_fields.addAll(Arrays.asList(ao_object.getClass().getFields()));
        lo_lst_fields.addAll(Arrays.asList(ao_object.getClass().getSuperclass().getDeclaredFields()));
        for (Field lo_field : lo_lst_fields) {
            lo_field.setAccessible(true);
            if (Modifier.isStatic(lo_field.getModifiers()) || Modifier.isFinal(lo_field.getModifiers())) continue;
            Class<?> lo_class = lo_field.getType();
            try {
                Object lo_value = lo_field.get(ao_object);
                if (lo_value == null || lo_class.isPrimitive()) continue;
                lo_field.set(ao_object, null);
                this.AllObjectsReflectionNull(lo_value);
                lo_value = lo_field.get(ao_object);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("1. Problema no campo " + lo_field.getName() + ": " + VeSException.MessageGet((Throwable)ex));
            }
            catch (IllegalAccessException ex) {
                LOGGER.info("2. Problema no campo " + lo_field.getName() + ": " + VeSException.MessageGet((Throwable)ex));
            }
            catch (Throwable e) {
                LOGGER.info("3. Problema no campo " + lo_field.getName() + ": " + VeSException.MessageGet((Throwable)e));
            }
        }
    }

    private boolean isNumber(byte[] number) {
        try {
            Integer.parseInt(new String(number));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void callback() {
        this.cleanInstance();
    }

    public byte[] getReadTemporary() {
        if (this.byteBufferTemporary == null) {
            return new byte[0];
        }
        byte[] temporary = new byte[this.byteBufferTemporary.array().length];
        this.byteBufferTemporary.get(temporary);
        this.byteBufferTemporary = null;
        return temporary;
    }

    public static Integer getDefaultLayoutConf() {
        return defaultLayoutConf;
    }

    public static void setDefaultLayoutConf(Integer defaultLayoutConf) {
        VSPagueClientMainInstance.defaultLayoutConf = defaultLayoutConf;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

