/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.active;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.active.ActivationEnvironment;
import vespague.client.active.ActiveResponse;
import vespague.client.active.GetActive;
import vespague.client.active.IActiveTerminalIntegration;
import vespague.client.active.PostActive;

/*
 * Exception performing whole class analysis ignored.
 */
public class ActiveClientIntegration
implements IActiveTerminalIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveClientIntegration.class);
    final ActivationEnvironment environment;

    public ActiveClientIntegration(ActivationEnvironment activationEnvironment) {
        this.environment = activationEnvironment;
    }

    private ActiveResponse getActive(GetActive request) {
        ActiveResponse activeRespose = null;
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(ActiveClientIntegration.getActiveUrl((String)this.environment.getUrl(), (String)request.getIdentifier(), (String)request.getSubscriptionCode())).openConnection();
        urlConnection.setDoOutput(false);
        urlConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(3L));
        urlConnection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(15L));
        urlConnection.setRequestMethod("GET");
        urlConnection.addRequestProperty("Content-Type", "application/json");
        urlConnection.addRequestProperty("Authorization", "Bearer " + this.environment.getToken());
        urlConnection.connect();
        Gson gson = new GsonBuilder().create();
        StringBuilder response = new StringBuilder();
        try {
            String line;
            BufferedReader reader = urlConnection.getResponseCode() == 200 ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            ActiveResponse activeResponse = activeRespose = (ActiveResponse)gson.fromJson(response.toString(), ActiveResponse.class);
            urlConnection.disconnect();
            return activeResponse;
        }
        catch (Throwable e) {
            try {
                try {
                    String message = "erro ao obter dados para ativacao de terminal";
                    LOGGER.error(message, e);
                    activeRespose = new ActiveResponse(message);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    urlConnection.disconnect();
                }
            }
            catch (IOException e2) {
                LOGGER.error("nao foi possivel obter informacoes de ativacao", (Throwable)e2);
            }
        }
        return activeRespose;
    }

    public static String getActiveUrl(String baseURL, String identifier, String subscriptionCode) {
        return String.valueOf(baseURL) + "?identifier=" + identifier + "&subscription_code=" + subscriptionCode;
    }

    private ActiveResponse postActive(PostActive request) {
        ActiveResponse activeRespose = null;
        HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.environment.getUrl()).openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(3L));
        urlConnection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(15L));
        urlConnection.setRequestMethod("POST");
        urlConnection.addRequestProperty("Content-Type", "application/json");
        urlConnection.addRequestProperty("Authorization", "Bearer " + this.environment.getToken());
        urlConnection.connect();
        Gson gson = new GsonBuilder().create();
        String body = gson.toJson((Object)request);
        urlConnection.getOutputStream().write(body.getBytes());
        StringBuilder response = new StringBuilder();
        try {
            String line;
            BufferedReader reader = urlConnection.getResponseCode() == 201 ? new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            ActiveResponse activeResponse = activeRespose = (ActiveResponse)gson.fromJson(response.toString(), ActiveResponse.class);
            urlConnection.disconnect();
            return activeResponse;
        }
        catch (Throwable e) {
            try {
                try {
                    LOGGER.error("erro ao realizar registro de terminal", e);
                    activeRespose = new ActiveResponse("Opera\u00e7\u00e3o falhou, clique no OK e tente novamente");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    urlConnection.disconnect();
                }
            }
            catch (IOException e2) {
                LOGGER.error("nao foi possivel obter informacoes de registro do terminal", (Throwable)e2);
            }
        }
        return activeRespose;
    }

    public ActiveResponse getTerminalSubscription(String documento, String codigoAssinatura) {
        GetActive request = GetActive.from((String)documento, (String)codigoAssinatura);
        LOGGER.debug("obtendo os dados para ativacao: {} / {}", (Object)documento, (Object)codigoAssinatura);
        return this.getActive(request);
    }

    public ActiveResponse postActiveTerminal(String documento, String codigoAssinatura, String hostName, String hostMac, String osName, String tipoTerminal, String modoProcessamento, String clientVersion) {
        PostActive postActive = PostActive.from((String)documento, (String)codigoAssinatura, (String)hostName, (String)hostMac, (String)osName, (String)"PDV", (String)modoProcessamento, (String)clientVersion);
        LOGGER.debug("enviado dados para ativacao: {}-{}-{}-{}-{}-{}-{}", new Object[]{documento, codigoAssinatura, hostName, hostMac, osName, "PDV", modoProcessamento});
        return this.postActive(postActive);
    }
}

