/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.active;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import lib.VeSUtil;
import lib.file.VBIFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.active.ActiveDataIntegration;

public class ActiveDataIntegrationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDataIntegrationUtil.class);
    private static final String PATH = ".config";
    private static final String FILE_NAME = "active.dat";

    public static void createDir(String estabelecimento, String loja, String terminal) {
        File file = new File(PATH);
        if (!file.exists()) {
            try {
                if (file.mkdir()) {
                    LOGGER.info("diretorio '.config' criado com sucesso");
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("falha na configuracao do diretorio '.config'.", e);
            }
        }
    }

    public static void save(String estabelecimento, String loja, String terminal, ActiveDataIntegration activeDataIntegration) {
        try {
            String nomeArquivo = PATH + File.separator + FILE_NAME;
            byte[] objetoSerializado = VeSUtil.ObjectToByte((Serializable)activeDataIntegration, (boolean)false);
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(nomeArquivo);){
                fileOutputStream.write(objetoSerializado);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error("erro ao gravar o arquivo de {}", (Object)FILE_NAME);
        }
    }

    public static ActiveDataIntegration get() {
        try {
            File file = new File(PATH + File.separator + FILE_NAME);
            if (file.exists()) {
                String nomeArquivo = PATH + File.separator + FILE_NAME;
                byte[] data = VBIFile.FileToByte((String)nomeArquivo);
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                    ObjectInputStream is = new ObjectInputStream(in);
                    ActiveDataIntegration baixaTecnica = (ActiveDataIntegration)is.readObject();
                    is.close();
                    return baixaTecnica;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("erro ao abrir o arquivo de {}", (Object)FILE_NAME, (Object)ex);
        }
        return null;
    }
}

