/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.configuration;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.configuration.Configuration;
import vespague.client.configuration.ConfigurationInstance;
import vespague.client.configuration.ConfigurationManager;
import vespague.client.configuration.ConfigurationUpdatedListener;
import vespague.client.configuration.remote.RemoteConfigurationClient;

public final class ConfigurationManager
implements ConfigurationInstance,
ConfigurationUpdatedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String PRODUCT_CODE = "CLIENT-DTX";
    private static ConfigurationManager configurationManager;
    private final Set<ConfigurationUpdatedListener> listeners = new HashSet();
    private final RemoteConfigurationClient remoteConfigurationClient;
    private final ConfigurationStorage storage = new ConfigurationStorage();
    private String document;
    private String identifier;
    private String terminalCode;
    private String appVersion;
    private Optional<Configuration> configuration;

    private ConfigurationManager(String remoteConfigUrl) {
        this.remoteConfigurationClient = remoteConfigUrl != null && !remoteConfigUrl.isEmpty() ? new RemoteConfigurationClient(remoteConfigUrl) : new RemoteConfigurationClient();
        this.configuration = this.storage.get();
        this.addUpdatedListener((ConfigurationUpdatedListener)this);
    }

    public Optional<Configuration> getConfiguration() {
        return this.configuration;
    }

    public boolean isConfigurated() {
        return this.configuration != null && this.configuration.isPresent();
    }

    public void configure(String document, String identifier, String terminalCode, String appVersion) {
        this.document = document;
        this.identifier = identifier;
        this.terminalCode = terminalCode;
        this.appVersion = appVersion;
    }

    public void checkConfiguration() {
        Thread configUpdateHandler = new Thread((Runnable)new ConfigurationUpdateHandler(this, this.remoteConfigurationClient));
        configUpdateHandler.setDaemon(true);
        configUpdateHandler.start();
    }

    public void checkConfigurationNow() {
        ConfigurationUpdateHandler handler = new ConfigurationUpdateHandler(this, this.remoteConfigurationClient);
        handler.run();
    }

    public void addUpdatedListener(ConfigurationUpdatedListener listener) {
        this.listeners.add(listener);
    }

    public void removeUpdatedListener(ConfigurationUpdatedListener listener) {
        this.listeners.remove(listener);
    }

    public static synchronized void init() {
        if (configurationManager == null) {
            configurationManager = new ConfigurationManager(null);
        }
    }

    public static synchronized void init(String remoteConfigUrl) {
        if (configurationManager == null) {
            configurationManager = new ConfigurationManager(remoteConfigUrl);
        }
    }

    public void onConfigurationUpdated(Configuration configuration) {
        this.configuration = Optional.of(configuration);
        LOGGER.info("configuracao remota atualizada. configurationId: {}, timestamp: {}", (Object)configuration.getConfigurationId().orElse(""), (Object)configuration.getTimestamp().orElse(""));
    }

    public static ConfigurationManager getInstance() {
        return configurationManager;
    }

    public static Optional<Configuration> get() {
        if (configurationManager == null) {
            return Optional.empty();
        }
        return configurationManager.getConfiguration();
    }

    static /* synthetic */ String access$0(ConfigurationManager configurationManager) {
        return configurationManager.document;
    }

    static /* synthetic */ String access$1(ConfigurationManager configurationManager) {
        return configurationManager.identifier;
    }

    static /* synthetic */ String access$2(ConfigurationManager configurationManager) {
        return configurationManager.terminalCode;
    }

    static /* synthetic */ String access$3(ConfigurationManager configurationManager) {
        return configurationManager.appVersion;
    }

    static /* synthetic */ ConfigurationStorage access$4(ConfigurationManager configurationManager) {
        return configurationManager.storage;
    }

    static /* synthetic */ Set access$5(ConfigurationManager configurationManager) {
        return configurationManager.listeners;
    }

    static /* synthetic */ Logger access$6() {
        return LOGGER;
    }
}

