/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.configuration.remote;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import vespague.client.configuration.Configuration;
import vespague.client.configuration.remote.ParameterValueConverter;
import vespague.client.configuration.remote.model.ConfigurationResponse;
import vespague.client.configuration.remote.model.Parameter;
import vespague.client.configuration.remote.model.ParameterType;

public class RemoteConfiguration
implements Configuration,
Serializable {
    private static final long serialVersionUID = 1113799434508676095L;
    private final String configurationId;
    private final String timestamp;
    private final Map<String, Object> parameters;
    private final LocalDateTime lastChecked = LocalDateTime.now();

    private RemoteConfiguration(ConfigurationResponse configurationResponse) {
        this.configurationId = configurationResponse.getConfigurationId();
        this.timestamp = configurationResponse.getTimestamp();
        this.parameters = configurationResponse.getParameters().stream().collect(Collectors.toMap(Parameter::getName, ParameterValueConverter::toObject));
    }

    public static Configuration from(ConfigurationResponse configurationResponse) {
        if (configurationResponse == null) {
            return null;
        }
        return new RemoteConfiguration(configurationResponse);
    }

    public Optional<LocalDateTime> getLastChecked() {
        return Optional.ofNullable(this.lastChecked);
    }

    public Optional<String> getConfigurationId() {
        return Optional.ofNullable(this.configurationId);
    }

    public Optional<String> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<String> getTefEndpoint() {
        return this.getValue(ParameterType.TEF_ENDPOINT.getValue());
    }

    public Optional<Integer> getTefPort() {
        return this.getValue(ParameterType.TEF_PORT.getValue());
    }

    public Optional<Boolean> isTefSelfSigned() {
        return this.getValue(ParameterType.TEF_SELF_SIGNED.getValue());
    }

    public Optional<Boolean> isNataxaEmbedded() {
        return this.getValue(ParameterType.NATAXA_EMBEDDED.getValue());
    }

    public Optional<String> getNataxaUrl() {
        return this.getValue(ParameterType.NATAXA_URL.getValue());
    }

    public Optional<Integer> getNataxaVersion() {
        return this.getValue(ParameterType.NATAXA_VERSION.getValue());
    }

    public <T> Optional<T> getValue(String parameterName) {
        if (this.parameters.containsKey(parameterName)) {
            return Optional.ofNullable(this.parameters.get(parameterName));
        }
        return Optional.empty();
    }
}

