/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.configuration.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.configuration.remote.model.ConfigurationResponse;
import vespague.client.configuration.remote.model.GetConfigurationRequest;

public class RemoteConfigurationClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteConfigurationClient.class);
    private static final String REMOTE_CONFIG_API_DEFAULT = "https://remote-config-lb.destaxa.com/loader/configuration";
    private final String REMOTE_CONFIG_URL;

    public RemoteConfigurationClient() {
        this.REMOTE_CONFIG_URL = REMOTE_CONFIG_API_DEFAULT;
    }

    public RemoteConfigurationClient(String remoteConfigURL) {
        this.REMOTE_CONFIG_URL = remoteConfigURL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationResponse getConfiguration(GetConfigurationRequest request) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.REMOTE_CONFIG_URL).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(3L));
            urlConnection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(8L));
            urlConnection.setRequestMethod("POST");
            urlConnection.addRequestProperty("Content-Type", "application/json");
            urlConnection.connect();
            Gson gson = new GsonBuilder().create();
            String body = gson.toJson((Object)request);
            urlConnection.getOutputStream().write(body.getBytes());
            StringBuilder response = new StringBuilder();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        if (urlConnection.getResponseCode() != 200) break;
                        ConfigurationResponse configurationResponse = (ConfigurationResponse)gson.fromJson(response.toString(), ConfigurationResponse.class);
                        if (configurationResponse != null) {
                            configurationResponse.configureStatus(true, urlConnection.getResponseCode());
                        }
                        ConfigurationResponse configurationResponse2 = configurationResponse;
                        return configurationResponse2;
                    }
                    response.append(line);
                }
                ConfigurationResponse configurationResponse = new ConfigurationResponse(true, urlConnection.getResponseCode());
                return configurationResponse;
            }
            catch (Throwable e) {
                if (urlConnection.getResponseCode() == 401) {
                    LOGGER.error("nao autenticado", e);
                } else {
                    urlConnection.getResponseMessage();
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                    String error = errorReader.readLine();
                    if (error != null) {
                        LOGGER.error("falha na consulta da configuracao remota. response_code: {}, response: {}", (Object)urlConnection.getResponseCode(), (Object)error);
                    } else {
                        LOGGER.error("falha na consulta de configuracao remota. response_code: {}", (Object)urlConnection.getResponseCode(), (Object)e);
                    }
                }
                ConfigurationResponse configurationResponse3 = new ConfigurationResponse(false, urlConnection.getResponseCode());
                return configurationResponse3;
            }
            finally {
                urlConnection.disconnect();
            }
        }
        catch (IOException e2) {
            LOGGER.error("nao foi possivel consultar a configuracao do dispositivo", (Throwable)e2);
            return new ConfigurationResponse(false, 0);
        }
    }
}

