/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.text.ParseException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import lib.VBIMain;
import lib.graphic.window.VBIWindowMain;
import vespague.client.active.ActiveDataIntegration;
import vespague.client.active.ActiveResponse;
import vespague.client.active.IActiveTerminalIntegration;
import vespague.client.graphic.ClientWindowActivePdv;
import vespague.client.lib.graphic.window.ClientGui;
import vespague.client.lib.graphic.window.VBIWindowMessage;
import vespague.common.VeSPagueUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientWindowActivePdv
extends JDialog {
    private JComboBox<String> tipoDocumentoCombo;
    private JFormattedTextField campoDocumento;
    private JTextField campoCodigoAssinatura;
    ActiveDataIntegration activeDataIntegration;

    public ClientWindowActivePdv(JFrame frameParent, IActiveTerminalIntegration activeClient) {
        super(frameParent, VBIMain.ApplicationTitleGet(), true);
        this.setSize(ClientGui.dimensionWindowPdvActiveMessageDefault.width, ClientGui.dimensionWindowPdvActiveMessageDefault.height);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setIconImage(VBIWindowMain.ImageGet() == null ? null : VBIWindowMain.ImageGet().getImage());
        JPanel painel = new JPanel();
        painel.setLayout(new GridLayout(4, 2, 10, 10));
        painel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel labelTipoDocumento = new JLabel("Tipo de Documento:");
        this.tipoDocumentoCombo = new JComboBox<String>(new String[]{"CNPJ", "CPF"});
        JLabel labelDocumento = new JLabel("Documento:");
        this.campoDocumento = new JFormattedTextField(this.createFormatter("AA.AAA.AAA/AAAA-##"));
        JLabel labelCodigo = new JLabel("C\u00f3digo de Assinatura:");
        this.campoCodigoAssinatura = new JTextField();
        this.campoDocumento.setFont(ClientGui.fontComponentWindowPdvActiveTextDefault);
        this.campoCodigoAssinatura.setFont(ClientGui.fontComponentWindowPdvActiveTextDefault);
        this.tipoDocumentoCombo.setFont(ClientGui.fontComponentWindowPdvActiveTextDefault);
        labelTipoDocumento.setFont(ClientGui.fontComponentWindowPdvActiveLabelDefault);
        labelTipoDocumento.setHorizontalAlignment(2);
        labelDocumento.setFont(ClientGui.fontComponentWindowPdvActiveLabelDefault);
        labelDocumento.setHorizontalAlignment(2);
        labelCodigo.setFont(ClientGui.fontComponentWindowPdvActiveLabelDefault);
        labelCodigo.setHorizontalAlignment(2);
        DefaultFormatterFactory defaultFormatterFactoryCNPJ = new DefaultFormatterFactory(this.createFormatter("AA.AAA.AAA/AAAA-##"));
        DefaultFormatterFactory defaultFormatterFactoryCPF = new DefaultFormatterFactory(this.createFormatter("###.###.###-##"));
        this.tipoDocumentoCombo.addActionListener(e -> {
            String tipoDocumento = (String)this.tipoDocumentoCombo.getSelectedItem();
            assert (tipoDocumento != null);
            this.campoDocumento.setValue(null);
            if (tipoDocumento.equals("CNPJ")) {
                this.campoDocumento.setFormatterFactory(defaultFormatterFactoryCNPJ);
            } else {
                this.campoDocumento.setFormatterFactory(defaultFormatterFactoryCPF);
            }
        });
        painel.add(labelTipoDocumento);
        painel.add(this.tipoDocumentoCombo);
        painel.add(labelDocumento);
        painel.add(this.campoDocumento);
        painel.add(labelCodigo);
        painel.add(this.campoCodigoAssinatura);
        JButton botaoAtivar = new JButton("Ativar");
        botaoAtivar.addActionListener(e -> {
            String documento = this.campoDocumento.getText().replaceAll("[^0-9]", "");
            if ("CNPJ".equals(this.tipoDocumentoCombo.getSelectedItem())) {
                documento = this.campoDocumento.getText().replaceAll("[^0-9A-Za-z]", "");
            }
            if (documento.isEmpty() && this.campoCodigoAssinatura.getText().isEmpty()) {
                VBIWindowMessage.ErrorShow((Object)"Informe os dados para ativa\u00e7\u00e3o.");
            } else {
                if (documento.isEmpty()) {
                    this.campoDocumento.setBackground(Color.YELLOW);
                    VBIWindowMessage.ErrorShow((Object)"Informe CNPJ/CPF");
                } else {
                    this.campoDocumento.setBackground(Color.WHITE);
                }
                if (this.campoCodigoAssinatura.getText().isEmpty()) {
                    this.campoCodigoAssinatura.setBackground(Color.YELLOW);
                    VBIWindowMessage.ErrorShow((Object)"Informe o c\u00f3digo de assinatura");
                } else {
                    this.campoCodigoAssinatura.setBackground(Color.WHITE);
                }
            }
            if (!documento.isEmpty() && !this.campoCodigoAssinatura.getText().isEmpty()) {
                ActiveResponse activeResponse = activeClient.getTerminalSubscription(documento, this.campoCodigoAssinatura.getText());
                if (activeResponse.getIdentifier() != null && activeResponse.getProcessingTypes() != null) {
                    ConfirmacaoAtivacao confirmacaoAtivacao = new ConfirmacaoAtivacao((JDialog)this, activeResponse.getIdentifier(), activeResponse.getSocialReason(), activeResponse.getProcessingTypes());
                    confirmacaoAtivacao.dispose();
                    String modoProcessamento = confirmacaoAtivacao.getModoProcessamento();
                    if (modoProcessamento != null) {
                        String hostName = VBIMain.HOST_NAME;
                        List listMac = VeSPagueUtil.getPhysicalMacAddresses();
                        String hostMac = (String)listMac.get(0);
                        activeResponse = activeClient.postActiveTerminal(documento, this.campoCodigoAssinatura.getText(), hostName, hostMac, VBIMain.OS_NAME, "PDV", modoProcessamento, VBIMain.ApplicationVersionGet().toString());
                        if (activeResponse.getMerchant() != null && activeResponse.getStore() != null && activeResponse.getTerminal() != null) {
                            this.activeDataIntegration = new ActiveDataIntegration(activeResponse.getIdentifier(), activeResponse.getMerchant(), activeResponse.getStore(), activeResponse.getTerminal(), modoProcessamento, activeResponse.isRequireActivation(), activeResponse.getMessage(), true);
                            this.activeDataIntegration.hostMac(hostMac);
                        } else {
                            this.activeDataIntegration = new ActiveDataIntegration(null, null, null, null, modoProcessamento, false, activeResponse.getMessage(), false);
                        }
                    }
                } else {
                    this.activeDataIntegration = new ActiveDataIntegration(activeResponse.getIdentifier(), null, null, null, null, false, activeResponse.getMessage(), false);
                }
                this.dispose();
            }
        });
        JButton botaoCancelar = new JButton("Cancelar");
        botaoCancelar.addActionListener(e -> this.dispose());
        painel.add(botaoCancelar);
        painel.add(botaoAtivar);
        this.add((Component)painel);
        ClientWindowActivePdv.toCenter((JDialog)this, (int)this.getWidth(), (int)this.getHeight());
        this.setVisible(true);
    }

    private MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return formatter;
    }

    public final ActiveDataIntegration getActiveData() {
        return this.activeDataIntegration;
    }

    public static void toCenter(JDialog window, int width, int height) {
        Dimension lo_dm_screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((lo_dm_screen_size.width - width) / 2, (lo_dm_screen_size.height - height) / 2, width, height);
    }
}

