/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import lib.VBIApplication;
import lib.VBIMain;
import lib.VeSUtil;
import lib.comm.VeSComm;
import lib.comm.structure.VeSCommSocketConfiguration;
import lib.type.VeSInteger;
import lib.xml.VBIXmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.automation.VSPagueClientAutomationInteractionDriver;
import vespague.client.InstanceCallback;
import vespague.client.VSPagueClientCommandLine;
import vespague.client.VSPagueClientMain;
import vespague.client.configuration.ConfigurationManager;
import vespague.client.graphic.VSPagueClientArguments;
import vespague.client.graphic.VSPagueClientLinux;
import vespague.client.graphic.VSPagueClientMac;
import vespague.client.graphic.VSPagueClientWindows;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.interaction.VSPagueClientToServerGenerateSimulatorFile;
import vespague.client.interaction.VeSPagueClientToServer;
import vespague.client.lib.comm.VSPagueClientCommAplicacaoComercial;

public class VSPagueClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueClient.class);
    private final String clientId;
    private static String APPLICATION_NAME;
    public static SortedMap<String, Object> io_hmp_instance;
    private static VBIApplication io_application;
    private static VSPagueClientCommandLine io_command_line;
    private final Class<? extends VeSPagueClientToServer> io_client_to_server;
    private boolean remoteConfiguration;

    static {
        io_application = null;
        io_command_line = null;
    }

    public VSPagueClient(String clientId, String as_application_name, String[] as_arguments, VSPagueClientCommandLine ao_command_line, Class<? extends VeSPagueClientToServer> ao_client_to_server) throws Throwable {
        this.clientId = clientId == null ? "vspg-id-" + UUID.randomUUID().toString().substring(28) : clientId;
        if (io_application == null) {
            APPLICATION_NAME = as_application_name;
            io_application = VeSPagueClient.createVSPagueVersao((String)APPLICATION_NAME);
        }
        if (io_command_line == null) {
            io_command_line = ao_command_line;
        }
        this.io_client_to_server = ao_client_to_server;
        String ls_porta_automacao = null;
        ls_porta_automacao = ao_command_line.ValueGet(ao_command_line.MerchantApplicationPortArgumentGet());
        if (ls_porta_automacao != null || (ls_porta_automacao = this.ArgumentoPortaAutomacaoRecebidoModeloAntigoGet(as_arguments)) != null) {
            this.PortaAutomacaoConsistir(ls_porta_automacao);
        }
    }

    public VSPagueClient(String clientId, String as_application_name, String[] as_arguments, VSPagueClientCommandLine ao_command_line, Class<? extends VeSPagueClientToServer> ao_client_to_server, boolean remoteConfiguration) throws Throwable {
        this(clientId, as_application_name, as_arguments, ao_command_line, ao_client_to_server);
        this.remoteConfiguration = remoteConfiguration;
    }

    @Deprecated
    private final String ArgumentoPortaAutomacaoRecebidoModeloAntigoGet(String[] as_arguments) {
        boolean lb_hidden_format = false;
        int ln_1 = 0;
        while (ln_1 < as_arguments.length && !(lb_hidden_format = as_arguments[ln_1].startsWith("-"))) {
            ++ln_1;
        }
        return !lb_hidden_format && as_arguments.length > 0 ? ((as_arguments[0].contains(":") || as_arguments[0].contains(";")) && as_arguments.length >= 2 ? as_arguments[1] : (as_arguments.length >= 3 ? as_arguments[2] : null)) : null;
    }

    private final void PortaAutomacaoConsistir(String as_porta_automacao) {
        String[] ls_portas = as_porta_automacao.split(",");
        if (ls_portas.length > 1 || ls_portas.length == 1 && ls_portas[0].contains("-")) {
            io_hmp_instance = new TreeMap();
            String[] stringArray = ls_portas;
            int n = ls_portas.length;
            int n2 = 0;
            while (n2 < n) {
                String ls_porta = stringArray[n2];
                if (ls_porta.contains("-")) {
                    String[] ls_range = ls_porta.split("-");
                    this.PortasIntervaloValidar(ls_range[0], ls_range[1]);
                } else {
                    this.PortasValidar(new String[]{ls_porta});
                }
                ++n2;
            }
        }
    }

    public final VeSPagueClient AplicacaoInstanciar() throws Throwable {
        return this.AplicacaoInstanciar(null, null, null);
    }

    public final VeSPagueClient AplicacaoInstanciar(VeSComm ao_comm, VeSCommSocketConfiguration ao_configuration, InstanceCallback callback) throws Throwable {
        VeSPagueClient lo_client = null;
        if (io_hmp_instance != null) {
            int ln_indice = 0;
            while (ln_indice < io_hmp_instance.size()) {
                VeSInteger ln_automacao_porta = new VeSInteger(io_hmp_instance.keySet().toArray()[ln_indice].toString());
                io_hmp_instance.put(ln_automacao_porta.toString(), this.InstanceBySystemOperation(io_application, new VSPagueClientArguments(io_command_line, ln_automacao_porta, ao_configuration != null ? ao_configuration : this.ArgumentsProcess()), this.io_client_to_server, ao_comm, callback));
                ++ln_indice;
            }
        } else {
            lo_client = this.InstanceBySystemOperation(io_application, new VSPagueClientArguments(io_command_line, io_command_line.ArgumentPresent(io_command_line.MerchantApplicationPortArgumentGet()) ? new VeSInteger(io_command_line.ValueGet(io_command_line.MerchantApplicationPortArgumentGet())) : null, ao_configuration != null ? ao_configuration : this.ArgumentsProcess()), this.io_client_to_server, ao_comm, callback);
        }
        return lo_client;
    }

    private final void PortasValidar(String[] as_portas) {
        String[] stringArray = as_portas;
        int n = as_portas.length;
        int n2 = 0;
        while (n2 < n) {
            String ls_porta = stringArray[n2];
            if (!VeSUtil.Decimal((String)ls_porta)) {
                throw new RuntimeException("Port (" + ls_porta + ") is not a number");
            }
            if (Integer.parseInt(ls_porta) < 1024 || Integer.parseInt(ls_porta) > 65535) {
                throw new RuntimeException("Reserved port: " + ls_porta);
            }
            if (as_portas.length > 1) {
                int ln_1 = Integer.parseInt(as_portas[0]);
                while (ln_1 <= Integer.parseInt(as_portas[1])) {
                    io_hmp_instance.put(String.valueOf(ln_1), null);
                    ++ln_1;
                }
            } else if (!io_hmp_instance.containsKey(ls_porta)) {
                io_hmp_instance.put(ls_porta, null);
            } else {
                throw new RuntimeException("Duplicate port: " + ls_porta);
            }
            ++n2;
        }
    }

    private final void PortasIntervaloValidar(String as_porta_inicio, String as_porta_fim) {
        this.PortasValidar(new String[]{as_porta_inicio, as_porta_fim});
        if (Integer.parseInt(as_porta_inicio) > Integer.parseInt(as_porta_fim)) {
            throw new RuntimeException("Initial port (" + as_porta_inicio + ") cannot be greater than the final port (" + as_porta_fim + ")");
        }
    }

    protected VeSPagueClient SoWindows(VBIApplication ao_version, VSPagueClientArguments ao_arguments, Class<? extends VeSPagueClientToServer> ac_client_to_server) throws Throwable {
        return new VSPagueClientWindows(this.clientId, ao_version, ao_arguments, ac_client_to_server);
    }

    protected VeSPagueClient SoLinux(VBIApplication ao_version, VSPagueClientArguments ao_arguments, Class<? extends VeSPagueClientToServer> ac_client_to_server) throws Throwable {
        return new VSPagueClientLinux(this.clientId, ao_version, ao_arguments, ac_client_to_server);
    }

    protected VeSPagueClient SoMac(VBIApplication ao_version, VSPagueClientArguments ao_arguments, Class<? extends VeSPagueClientToServer> ac_client_to_server) throws Throwable {
        return new VSPagueClientMac(this.clientId, ao_version, ao_arguments, ac_client_to_server);
    }

    private final VeSPagueClient InstanceBySystemOperation(VBIApplication ao_version, VSPagueClientArguments ao_arguments, Class<? extends VeSPagueClientToServer> ac_client_to_server, VeSComm ao_comm, InstanceCallback callback) throws Throwable {
        VeSPagueClient lo_client = null;
        if (VBIMain.OS_NAME.startsWith("Windows")) {
            lo_client = this.SoWindows(ao_version, ao_arguments, ac_client_to_server);
        } else if (VBIMain.OS_NAME.startsWith("Linux")) {
            lo_client = this.SoLinux(ao_version, ao_arguments, ac_client_to_server);
        } else if (VBIMain.OS_NAME.startsWith("Mac OS")) {
            lo_client = this.SoMac(ao_version, ao_arguments, ac_client_to_server);
        } else {
            throw new Throwable("Sistema operacional \"" + VBIMain.OS_NAME + " n\u00e3o reconhecido pelo " + APPLICATION_NAME);
        }
        if (ao_comm == null) {
            lo_client.io_transaction_manager.Start();
        } else {
            lo_client.ApplicationUnlock();
            lo_client.in_mode = 3;
            VeSPagueClient.VISIBLE = false;
            lo_client.ConnectionMainSet(ao_comm);
            lo_client.io_transaction_manager.io_client_to_server.io_client_automation_interaction = new VSPagueClientAutomationInteractionDriver(lo_client.io_transaction_manager, (VeSComm)new VSPagueClientCommAplicacaoComercial(lo_client.getClientId(), ao_comm), callback);
        }
        return lo_client;
    }

    private final VeSCommSocketConfiguration ArgumentsProcess() throws VBIXmlException {
        VeSCommSocketConfiguration lo_cfg_socket = new VeSCommSocketConfiguration();
        lo_cfg_socket.in_mode = new VeSInteger(0L);
        lo_cfg_socket.ib_secure_socket_layer = true;
        lo_cfg_socket.in_reconnect_automatic_delay = 0L;
        lo_cfg_socket.in_connect_timeout = 3000;
        lo_cfg_socket.in_reconnect_wait_time = (long)lo_cfg_socket.in_connect_timeout.intValue() * 2L + 1000L;
        if (io_command_line == null || !io_command_line.manterClientConectado()) {
            lo_cfg_socket.in_break_idle_time = 200;
        }
        lo_cfg_socket.ib_trace = io_command_line.ArgumentExists(io_command_line.ServerTraceArgumentGet());
        String ls_host = null;
        String ls_port = null;
        if (io_command_line.ArgumentsGet().length > 0) {
            if (io_command_line.LegadoManter()) {
                ls_host = io_command_line.ArgumentsGet()[0];
                if (io_command_line.ArgumentsGet().length >= 2) {
                    ls_port = io_command_line.ArgumentsGet()[0].contains(":") ? null : io_command_line.ArgumentsGet()[1];
                }
            } else {
                ls_host = io_command_line.ValueGet(io_command_line.ServerHostArgumentGet());
                ls_port = io_command_line.ValueGet(io_command_line.ServerDefaultPortArgumentGet());
            }
        }
        if (!this.remoteConfiguration) {
            lo_cfg_socket.is_host = ls_host == null ? io_command_line.DefaultHostGet() : ls_host;
            lo_cfg_socket.in_port = ls_port == null ? io_command_line.DefaultPortGet() : new VeSInteger(ls_port);
        }
        return lo_cfg_socket;
    }

    public static void main(String[] as_arguments) {
        String ls_application_name = "V$PagueClient";
        try {
            VSPagueClientCommandLine lo_command_line = new VSPagueClientCommandLine(as_arguments);
            Class<VeSPagueClientToServer> lo_client_to_server = VeSPagueClientToServer.class;
            int ln_1 = 0;
            while (ln_1 < as_arguments.length && as_arguments[ln_1].hashCode() != 1443245) {
                ++ln_1;
            }
            if (ln_1 < as_arguments.length && VBIMain.HostSoftwareAddressGet((String)"127.0.0.1").substring(0, 4).hashCode() == 1654485) {
                lo_client_to_server = VSPagueClientToServerGenerateSimulatorFile.class;
            }
            if (lo_command_line.ArgumentExists(lo_command_line.EstabelecimentoLojaTerminal()) && lo_command_line.ValueGet(lo_command_line.EstabelecimentoLojaTerminal()).equals("x")) {
                LOGGER.info("Driver com Inst\u00e2ncia Autom\u00e1tica de V$PagueClient");
                VSPagueClientMain lo_cli_main = new VSPagueClientMain(lo_command_line, lo_command_line.ArgumentExists(lo_command_line.MerchantApplicationPortArgumentGet()) ? Integer.valueOf(lo_command_line.ValueGet(lo_command_line.MerchantApplicationPortArgumentGet())) : 60906);
                lo_cli_main.Start();
            } else {
                boolean remoteConfiguration = true;
                if (lo_command_line.ArgumentExists(lo_command_line.remoteConfig())) {
                    ConfigurationManager.init();
                    LOGGER.info("configuracao remota habilitada");
                } else if (lo_command_line.ArgumentExists(lo_command_line.remoteConfigDev())) {
                    String remoteConfigUrl = lo_command_line.ValueGet(lo_command_line.remoteConfigDev());
                    ConfigurationManager.init((String)remoteConfigUrl);
                    LOGGER.info("configuracao remota habilitada em modo dev {}", (Object)remoteConfigUrl);
                } else {
                    remoteConfiguration = false;
                }
                VSPagueClient lo_client = new VSPagueClient(null, ls_application_name, as_arguments, lo_command_line, lo_client_to_server, remoteConfiguration);
                lo_client.AplicacaoInstanciar();
            }
        }
        catch (Throwable twb) {
            LOGGER.error(ls_application_name, twb);
            VBIMain.ApplicationExecutionError((String)ls_application_name, (Throwable)twb);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    protected void finalize() throws Throwable {
        LOGGER.info(String.format("%s: %s", this.getClientId(), "finalizado"));
        super.finalize();
    }
}

