/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import lib.VeSUtil;
import lib.file.VBIFile;
import lib.type.VBIDatetime;
import lib.type.VeSInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.graphic.VSPagueClientLog;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.util.LogFormatterUtil;
import vespague.common.VeSPagueClientUtil;
import vespague.common.VeSPagueUtil;
import vespague.structure.VeSPagueTransacao;

/*
 * Exception performing whole class analysis ignored.
 */
public class VSPagueClientLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueClientLog.class);
    private VeSPagueClient io_client;
    private VeSPagueUtil.TransactionResolve io_transaction_resolve;
    private static final int PERNA = 0;
    private static final int SEQUENCIAL_CLIENT = 1;
    private static final int DATA = 0;
    private static final int SEQUENCIAL = 1;
    private static final int TRANSACAO = 2;
    private static final int NSU = 3;
    private static final int VALOR = 4;
    private static final int RESPOSTA = 5;
    private static final int REDE = 6;
    private static final int NSU_REDE = 7;
    private SortedMap<Long, SortedMap<Integer, Transacao>> transacoes = new TreeMap();

    public VSPagueClientLog(VeSPagueClient ao_client) {
        this.io_client = ao_client;
        this.io_transaction_resolve = new VeSPagueUtil.TransactionResolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void LogRecorder(VeSPagueTransacao ao_transaction) {
        if (ao_transaction.in_perna != null) {
            try {
                VeSPagueUtil.TransactionResolve transactionResolve = this.io_transaction_resolve;
                synchronized (transactionResolve) {
                    LogFormatterUtil.logTransaction((String)this.io_client.getClientId(), (VeSPagueTransacao)ao_transaction);
                    String key = ao_transaction.in_perna + ";" + ao_transaction.in_sequencial_client;
                    String value = String.valueOf(new VBIDatetime().toString("dd/MM/yyyy HH:mm:ss")) + ";" + ao_transaction.in_sequencial + ";" + ao_transaction.is_tipo + ";" + ao_transaction.in_nsu + ";" + ao_transaction.in_valor + ";" + ao_transaction.is_resposta + ";" + ao_transaction.is_rede + ";" + ao_transaction.in_nsu_rede;
                    if (this.io_transaction_resolve.io_respostas.containsKey(key)) {
                        String keyPerna = ";" + ao_transaction.in_sequencial_client;
                        this.io_transaction_resolve.io_respostas.remove("1" + keyPerna);
                        this.io_transaction_resolve.io_respostas.remove("2" + keyPerna);
                        this.io_transaction_resolve.io_respostas.remove("3" + keyPerna);
                    }
                    this.io_transaction_resolve.io_respostas.put(key, value);
                    this.addLogTransacao(key, value);
                }
                String ls_date = new VBIDatetime().toString("yyyyMMdd");
                if (!this.io_transaction_resolve.io_datas.containsKey(ls_date)) {
                    this.io_transaction_resolve.io_datas.put(ls_date, new ArrayList());
                }
                if (ao_transaction.in_perna != null && ao_transaction.in_sequencial_client != null) {
                    ((ArrayList)this.io_transaction_resolve.io_datas.get(ls_date)).add(ao_transaction.in_perna + "/" + ao_transaction.in_sequencial_client);
                }
                this.LogCleaner();
                if (ao_transaction.contraSenha != null) {
                    this.io_transaction_resolve.setContraSenha(ao_transaction.contraSenha.intValue());
                    this.io_transaction_resolve.setUltimaTransacaoRealizada(Instant.now());
                }
                if (ao_transaction.getBaixarConf() != null && ao_transaction.getBaixarConf().booleanValue() && !this.io_transaction_resolve.getBaixarConf()) {
                    LOGGER.info("recebeu indicativo para baixar .conf");
                    this.io_transaction_resolve.setBaixarConf(true);
                    ao_transaction.setBaixarConf(Boolean.valueOf(false));
                }
                this.saveLogDisk(this.io_transaction_resolve);
            }
            catch (Exception ex) {
                LOGGER.error("erro ao salvar o arquivo de .log", (Throwable)ex);
            }
        }
    }

    public void removeTransaction(VeSInteger perna, VeSInteger sequencialClient) {
        if (this.io_transaction_resolve != null) {
            String key = perna + ";" + sequencialClient;
            this.io_transaction_resolve.io_respostas.remove(key);
        }
    }

    public void saveLogDisk(VeSPagueUtil.TransactionResolve transactionResolve) throws VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        VBIFile.ObjectToFile((String)this.io_client.NomeArquivoLogCriar(), (Object)this.io_transaction_resolve, (boolean)true);
    }

    public Transacao findByTransacaoNsu(VeSInteger transacaoNsu) {
        for (Map.Entry transacaoMap : this.transacoes.entrySet()) {
            Transacao transacaoObj;
            Map transacao = (Map)transacaoMap.getValue();
            if (transacao.size() != 3 || (transacaoObj = (Transacao)transacao.get(3)) == null || transacaoObj.getNsu() != transacaoNsu.intValue()) continue;
            return transacaoObj;
        }
        return null;
    }

    public Transacao findByTransacaoNsuPending(VeSInteger transacaoNsu) {
        for (Map.Entry transacaoMap : this.transacoes.entrySet()) {
            Transacao transacaoObj;
            Map transacao = (Map)transacaoMap.getValue();
            if (transacao.size() <= 1 || transacao.size() != 2 || (transacaoObj = (Transacao)transacao.get(2)) == null || transacaoObj.getNsu() != transacaoNsu.intValue()) continue;
            return transacaoObj;
        }
        return null;
    }

    public Transacao findByTransacaoPending(int nsu, LocalDate dataHora, String rede) {
        for (Map.Entry transacaoMap : this.transacoes.entrySet()) {
            Transacao transacaoObj;
            Map transacao = (Map)transacaoMap.getValue();
            if (transacao.size() <= 1 || transacao.size() != 2 || (transacaoObj = (Transacao)transacao.get(2)) == null || transacaoObj.getNsu() != nsu || !transacaoObj.getRede().equals(rede) || !transacaoObj.getDataHora().toLocalDate().equals(dataHora)) continue;
            return transacaoObj;
        }
        return null;
    }

    public Transacao findBySequencialClientPending(Long sequencialClient) {
        Map transacoesLog;
        if (this.transacoes.containsKey(sequencialClient) && (transacoesLog = (Map)this.transacoes.get(sequencialClient)).size() > 1 && !transacoesLog.containsKey(3)) {
            Transacao transacao = (Transacao)transacoesLog.get(2);
            return transacao;
        }
        return null;
    }

    public Transacao findBySequencialClient(Long sequencialClient) {
        Map transacoesLog;
        if (this.transacoes.containsKey(sequencialClient) && (transacoesLog = (Map)this.transacoes.get(sequencialClient)).containsKey(3)) {
            Transacao transacao = (Transacao)transacoesLog.get(3);
            return transacao;
        }
        return null;
    }

    private SortedMap<String, String> getTransacaoLog() {
        TreeMap<String, String> mapTransacoes = new TreeMap<String, String>();
        for (String ls_chave : this.io_transaction_resolve.io_respostas.keySet()) {
            mapTransacoes.put((String)this.io_transaction_resolve.io_respostas.get(ls_chave), ls_chave);
        }
        return mapTransacoes;
    }

    public final void LogLastTransactionRecorder(VeSPagueTransacao ao_transaction) {
        if (ao_transaction.in_perna != null && ao_transaction.in_perna.compareTo(1L) == 0) {
            ao_transaction.in_transacao_pendente_vespague_codigo = new VeSInteger[1];
            ao_transaction.is_transacao_pendente_transacao_resposta = new String[1];
            ao_transaction.in_transacao_pendente_perna = new VeSInteger[1];
            if (this.io_transaction_resolve.io_respostas != null && this.io_transaction_resolve.io_respostas.size() > 0) {
                SortedMap lo_smp_reverso = this.getTransacaoLog();
                String[] ls_valor = ((String)lo_smp_reverso.lastKey()).split(";");
                ao_transaction.in_transacao_pendente_vespague_codigo[0] = "null".equals(ls_valor[1]) ? null : new VeSInteger(ls_valor[1]);
                ao_transaction.is_transacao_pendente_transacao_resposta[0] = ls_valor[5];
                Set lo_conjunto = lo_smp_reverso.entrySet();
                Iterator lo_iterator = lo_conjunto.iterator();
                String ls_perna = null;
                while (lo_iterator.hasNext()) {
                    Map.Entry lo_entrada = lo_iterator.next();
                    ls_perna = ((String)lo_entrada.getValue()).split(";")[0];
                }
                ao_transaction.in_transacao_pendente_perna[0] = "null".equals(ls_perna) ? null : new VeSInteger(ls_perna);
            } else {
                ao_transaction.in_transacao_pendente_vespague_codigo[0] = null;
                ao_transaction.is_transacao_pendente_transacao_resposta[0] = null;
                ao_transaction.in_transacao_pendente_perna[0] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void LogCleaner() {
        if (this.io_transaction_resolve.io_datas != null && !this.io_transaction_resolve.io_datas.isEmpty()) {
            String ls_date = new VBIDatetime().toString("yyyyMMdd");
            VeSPagueUtil.TransactionResolve transactionResolve = this.io_transaction_resolve;
            synchronized (transactionResolve) {
                Iterator lo_dates = this.io_transaction_resolve.io_datas.keySet().iterator();
                while (lo_dates.hasNext()) {
                    String ls_old_date = lo_dates.next().toString();
                    if (Integer.parseInt(ls_old_date) >= Integer.parseInt(ls_date) - 7) continue;
                    ArrayList lo_arl_key = (ArrayList)this.io_transaction_resolve.io_datas.get(ls_old_date);
                    int ln_1 = 0;
                    while (ln_1 < lo_arl_key.size()) {
                        this.io_transaction_resolve.io_respostas.remove(lo_arl_key.get(ln_1++));
                    }
                    lo_dates.remove();
                    this.transacoes.clear();
                    for (String key : this.io_transaction_resolve.io_respostas.keySet()) {
                        String[] keys = key.split(";");
                        String[] values = ((String)this.io_transaction_resolve.io_respostas.get(key)).split(";");
                        this.addLogTransacoes(keys, values);
                    }
                }
            }
        }
    }

    public final String LogStatusGet(VeSInteger ao_sequencial) {
        Iterator lo_itr_conjunto_chave = this.io_transaction_resolve.io_respostas.entrySet().iterator();
        String ls_resposta = null;
        while (lo_itr_conjunto_chave.hasNext()) {
            Map.Entry lo_etr_dados = lo_itr_conjunto_chave.next();
            String[] ls_valor = ((String)lo_etr_dados.getValue()).split(";");
            String[] ls_chave = ((String)lo_etr_dados.getKey()).split(";");
            if (!VeSUtil.Decimal((String)ls_valor[1]) || ao_sequencial.compareTo((BigInteger)new VeSInteger(ls_valor[1])) != 0 || !"3".equals(ls_chave[0])) continue;
            ls_resposta = !VeSPagueClientUtil.TRANSACAO_RESPOSTA_OK_GRUPO.contains(ls_valor[5]) ? "078" : "000";
            break;
        }
        return ls_resposta;
    }

    public final void TransactionResolveSet(VeSPagueUtil.TransactionResolve ao_transaction_resolve) {
        this.io_transaction_resolve = ao_transaction_resolve;
        for (String key : this.io_transaction_resolve.io_respostas.keySet()) {
            String[] keys = key.split(";");
            String[] values = ((String)this.io_transaction_resolve.io_respostas.get(key)).split(";");
            this.addLogTransacoes(keys, values);
        }
    }

    public final VeSPagueUtil.TransactionResolve TransactionResolveGet() {
        return this.io_transaction_resolve;
    }

    private void addLogTransacao(String key, String value) {
        SortedMap transacao;
        String[] keys = key.split(";");
        int perna = Integer.valueOf(keys[0]);
        long sequencialClient = Long.valueOf(keys[1]);
        if (this.transacoes.containsKey(sequencialClient) && perna == 1 && (transacao = (SortedMap)this.transacoes.get(sequencialClient)).containsKey(perna)) {
            this.transacoes.remove(sequencialClient);
        }
        this.addLogTransacoes(keys, value.split(";"));
    }

    private void addLogTransacoes(String[] keys, String[] values) {
        int perna = Integer.valueOf(keys[0]);
        long sequencialClient = Long.valueOf(keys[1]);
        SortedMap<Integer, Transacao> transacaoMap = new TreeMap();
        if (this.transacoes.containsKey(sequencialClient)) {
            transacaoMap = (SortedMap)this.transacoes.get(sequencialClient);
        }
        if (!transacaoMap.containsKey(perna)) {
            Transacao transacao = this.criarTransacao(values);
            Transacao.access$0((Transacao)transacao, (int)perna);
            Transacao.access$1((Transacao)transacao, (long)sequencialClient);
            transacaoMap.put(perna, transacao);
            this.transacoes.put(sequencialClient, transacaoMap);
        }
    }

    private Transacao criarTransacao(String[] value) {
        Transacao transacao = new Transacao(this);
        if (!value[0].isEmpty()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
            LocalDateTime dataHora = LocalDateTime.parse(value[0], formatter);
            Transacao.access$2((Transacao)transacao, (LocalDateTime)dataHora);
        }
        if (!value[1].isEmpty()) {
            try {
                Transacao.access$3((Transacao)transacao, (long)Long.valueOf(value[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!value[3].isEmpty()) {
            try {
                Transacao.access$4((Transacao)transacao, (int)Integer.valueOf(value[3]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!value[2].isEmpty()) {
            Transacao.access$5((Transacao)transacao, (String)value[2]);
        }
        if (!value[7].isEmpty()) {
            try {
                Transacao.access$6((Transacao)transacao, (long)Long.valueOf(value[7]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!value[6].isEmpty()) {
            Transacao.access$7((Transacao)transacao, (String)value[6]);
        }
        if (!value[5].isEmpty()) {
            Transacao.access$8((Transacao)transacao, (String)value[5]);
        }
        if (!value[4].isEmpty()) {
            try {
                Transacao.access$9((Transacao)transacao, (BigDecimal)new BigDecimal(value[4]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return transacao;
    }
}

