/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lib.graphic.VeSTable;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueTransacaoComponenteManipular;
import vespague.client.interaction.VeSPagueClientTransactionManager;
import vespague.client.lib.graphic.window.ClientGui;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueProcessamentoException;

public abstract class VeSPagueTabelaGenerico
extends JScrollPane
implements VeSPagueTransacaoComponenteManipular {
    public VeSTable io_tbl_table;
    protected VeSPagueClientTransactionManager io_transaction_manager;
    private int in_datastore_estado = -1;

    public VeSPagueTabelaGenerico(Object[][] ao_elementos, int an_width) {
        this.io_tbl_table = new VeSTable(0, ao_elementos);
        this.getViewport().setView((Component)this.io_tbl_table);
        this.Inicializa(an_width);
    }

    private void Inicializa(int an_width) {
        this.setSize(an_width, 200);
        this.ConfigurarFonteTabela();
        this.ConfigurarColunasResponsivas();
        this.setEnabled(true);
    }

    private void ConfigurarFonteTabela() {
        Font fonteTabela = ClientGui.fontComponentTabelaGenerica;
        this.io_tbl_table.setFont(fonteTabela);
        if (this.io_tbl_table.getTableHeader() != null) {
            Font fonteCabecalho = ClientGui.fontComponentTabelaGenericaCabecalho;
            this.io_tbl_table.getTableHeader().setFont(fonteCabecalho);
        }
        this.io_tbl_table.setRowHeight(25);
    }

    private void ConfigurarColunasResponsivas() {
        this.io_tbl_table.setAutoResizeMode(4);
        TableColumnModel columnModel = this.io_tbl_table.getColumnModel();
        if (columnModel.getColumnCount() > 0) {
            int i = 0;
            while (i < columnModel.getColumnCount()) {
                TableColumn column = columnModel.getColumn(i);
                column.setMinWidth(80);
                column.setMaxWidth(Integer.MAX_VALUE);
                ++i;
            }
        }
    }

    public void DefinirTamanhoFonte(int tamanhoFonte) {
        Font novaFonte = new Font("Dialog", 0, tamanhoFonte);
        this.io_tbl_table.setFont(novaFonte);
        this.io_tbl_table.setRowHeight(tamanhoFonte + 9);
        if (this.io_tbl_table.getTableHeader() != null) {
            Font fonteCabecalho = new Font("Dialog", 1, tamanhoFonte + 2);
            this.io_tbl_table.getTableHeader().setFont(fonteCabecalho);
        }
    }

    public void ConfigurarLargurasColunas(double[] porcentagens) {
        TableColumnModel columnModel = this.io_tbl_table.getColumnModel();
        if (porcentagens.length != columnModel.getColumnCount()) {
            throw new IllegalArgumentException("N\u00famero de porcentagens deve ser igual ao n\u00famero de colunas");
        }
        int larguraTotal = this.getWidth() > 0 ? this.getWidth() : 600;
        int i = 0;
        while (i < porcentagens.length) {
            TableColumn column = columnModel.getColumn(i);
            int larguraColuna = (int)((double)larguraTotal * porcentagens[i]);
            column.setPreferredWidth(larguraColuna);
            column.setMinWidth(Math.max(50, larguraColuna / 3));
            ++i;
        }
    }

    public final void ColunaCheckBoxDesmarcar(int an_coluna_desmarcar, int an_ultima_linha_marcada) {
        int i = 0;
        while (i < this.io_tbl_table.getRowCount()) {
            if (i != an_ultima_linha_marcada) {
                this.io_tbl_table.setValueAt((Object)new Boolean(false), i, an_coluna_desmarcar);
            }
            ++i;
        }
        this.io_tbl_table.repaint();
    }

    public final void FluxoRetroceder() {
        try {
            this.io_transaction_manager.io_datastore.Back(this.in_datastore_estado);
        }
        catch (Exception ao_exception) {
            VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
            veSPagueClient.getClass();
            new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ao_exception);
        }
    }

    public final void FluxoSalvar() {
        this.in_datastore_estado = this.io_transaction_manager.io_datastore.UltimoEstadoSalvolGet();
    }

    public final void Configurar(VeSPagueClientTransactionManager ao_interface) throws IllegalArgumentException {
        if (ao_interface == null) {
            throw new IllegalArgumentException("ao_interface n\u00e3o pode ser null.");
        }
        this.io_transaction_manager = ao_interface;
    }

    protected abstract void DadoSet(String var1);

    public void DadoReset() {
        this.DadoSet(null);
        this.Reset();
    }

    public JComponent[] ComponenteUsuarioInteracaoGet() {
        return new JComponent[]{this.io_tbl_table};
    }

    public void Reset() {
    }

    public void setEditable(boolean ab_editable) {
        this.setEnabled(ab_editable);
    }

    public String HintGet() {
        return null;
    }

    public boolean ComponenteUsuarioInteracaoSet(JComponent[] ao_componentes) {
        return false;
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        this.setVisible(this.io_transaction_manager.TransactionGet().is_tipo.equals(VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_MANUTENCAO_REDE_CONSULTAR));
    }

    public void coletar() {
    }

    public String getCollectValue() {
        return "";
    }
}

