/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueListaBaseGenerica;
import vespague.client.graphic.VeSPagueNoFocusChangeSign;
import vespague.client.graphic.transacao.VeSPagueWindowProcessar;
import vespague.client.graphic.transacao.cartao.VSPagueListaTransacaoTipoCartao;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VSPagueCartaoBandeiraAid;
import vespague.structure.VeSPagueTransacao;
import vespague.structure.VeSPagueValorLojaRedeConfiguracao;

public class VSPagueListaTransacaoTipoCartaoMultiplo
extends VeSPagueListaBaseGenerica {
    public VSPagueListaTransacaoTipoCartaoMultiplo() {
        super("Cart\u00e3o M\u00faltiplo");
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean isCollect = this.isCollect();
        this.setVisible(isCollect);
        if (isCollect) {
            this.setHorizontalScrollBarPolicy(31);
            VeSPagueTransacao.TransacaoCartao card = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet();
            card.setTipoCartaoOriginal(card.is_tipo);
            String applicationType = this.io_transaction_manager.io_client.PinpadGet().in_cartao_aplicacao_tipo == 1 ? VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO : VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO;
            this.io_lt_list.setListData((Object[])new String[]{applicationType, VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER});
            if (!VeSPagueClient.VISIBLE) {
                if (this.FixedValueGet() == null) {
                    this.DadoColetar("transacao_tipo_cartao", null);
                } else {
                    this.FixedValueSet();
                }
            } else {
                super.PreConsistenciaFazer();
            }
        }
    }

    protected Object FixedValueGet() {
        return null;
    }

    protected void DadoSet(String as_dado) {
        if (!this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo.equals(as_dado)) {
            this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo = as_dado.equals(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER) ? VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO : as_dado;
        }
    }

    public void FluxoRetroceder() {
        try {
            if (this.io_transaction_manager.io_client.PinpadGet() != null) {
                this.io_transaction_manager.io_client.PinpadGet().resetaComunicacao();
            }
        }
        catch (Exception e) {
            LOGGER.error("erro ao fechar comunicacao com o pinpad", (Throwable)e);
        }
        this.ParametersGet().TransacaoCartaoGet().is_cartao_numero = null;
        this.ParametersGet().TransacaoCartaoGet().ih_cartao_numero = null;
        this.io_transaction_manager.io_client.PinpadGet().in_cartao_contactless_situacao = 0;
        VeSPagueWindowProcessar.ComponentSendCommandToItsWindow((JComponent)this.io_lt_list, (Object)VeSPagueWindowProcessar.COMMAND_COMPONENT_RESET_WINDOWS_WITHOUT_TRANSACAO);
        if (VeSPagueClient.VISIBLE) {
            this.io_transaction_manager.io_wn_processar.ComponentBackToIndex(VSPagueListaTransacaoTipoCartao.class);
        } else {
            this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueListaTransacaoTipoCartao.class);
        }
    }

    public void DadoConsistir() throws VeSPagueProcessamentoException, VeSPagueNoFocusChangeSign {
        super.DadoConsistir();
        String select = Objects.requireNonNull(this.io_lt_list.getSelectedItem()).toString();
        if (this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo.equals(select)) {
            this.FluxoRetroceder();
        }
    }

    public boolean isCollect() {
        if (this.io_transaction_manager.io_client.PinpadGet() == null || this.io_transaction_manager.TransactionGet().TransacaoCartaoGet() == null || !"Contactless".equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada) || VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER.equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo) || this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().getTipoCartaoOriginal() != null) {
            return false;
        }
        String aid = this.getAid();
        return aid != null && this.getAidsPatAndVoucher().contains(aid);
    }

    private String getAid() {
        VeSPaguePinpad pinpad = this.io_transaction_manager.io_client.PinpadGet();
        try {
            int acquirerIndex = this.io_transaction_manager.DatastoreGet().EMVIndexToNet(pinpad.in_cartao_rede_adquirente.intValue(), pinpad.in_cartao_registro_indice.intValue());
            int aidIndex = this.io_transaction_manager.DatastoreGet().AIDIndexToArrayIndex(acquirerIndex, pinpad.in_cartao_registro_indice.intValue());
            VeSPagueValorLojaRedeConfiguracao acquirerConfiguration = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro[acquirerIndex].io_valor_loja_rede;
            return acquirerConfiguration.io_chip[aidIndex].is_application_identifier;
        }
        catch (VeSPagueProcessamentoException e) {
            LOGGER.error("erro ao buscar aid", (Throwable)e);
            return null;
        }
    }

    private List<String> getAidsPatAndVoucher() {
        Predicate<VSPagueCartaoBandeiraAid> isPatAndVoucher = aid -> aid.isPat() && aid.isVoucher();
        VSPagueCartaoBandeiraAid[] aids = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_application_identifier;
        return Arrays.stream(aids).filter(isPatAndVoucher).map(VSPagueCartaoBandeiraAid::ApplicationIdentifierGet).collect(Collectors.toList());
    }
}

