/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao;

import lib.type.VeSDecimal;
import vespague.client.graphic.VeSPagueCampoBaseDinheiroGenerico;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueNoFocusChangeSign;
import vespague.client.graphic.VeSPagueTransactionFieldUtil;
import vespague.common.VeSPagueClientUtil;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VeSPagueConfiguracaoPesquisar;

public class VeSPagueCampoTransacaoTaxaEmbarqueValor
extends VeSPagueCampoBaseDinheiroGenerico {
    public VeSPagueCampoTransacaoTaxaEmbarqueValor() {
        this(null);
    }

    public VeSPagueCampoTransacaoTaxaEmbarqueValor(VeSDecimal an_valor_maximo) {
        this(an_valor_maximo, null);
    }

    public VeSPagueCampoTransacaoTaxaEmbarqueValor(VeSDecimal an_valor_maximo, String as_texto) {
        super(VALOR_MINIMO_DEFAULT, an_valor_maximo, as_texto, "Taxa de Embarque");
    }

    public VeSPagueCampoTransacaoTaxaEmbarqueValor(String as_texto) {
        this(null, as_texto);
    }

    protected void DadoSet(VeSDecimal an_dado) {
        this.io_transaction_manager.TransactionGet().in_taxa_embarque = an_dado != null && an_dado.compareTo(0L) != 0 ? an_dado : null;
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean lb_coletar = this.isCollect();
        if (VeSPagueClient.VISIBLE) {
            this.setVisible(lb_coletar);
        } else {
            this.setVisible(false);
        }
        if (!(!lb_coletar || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_FINANCIADO.equals(this.io_transaction_manager.TransactionGet().is_tipo) && VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_ENDERECO.equals(this.io_transaction_manager.TransactionGet().is_tipo))) {
            if (!this.isVisible() && this.FixedValueGet() == null) {
                this.DadoColetar("transacao_valor_taxa_embarque", ".##");
                this.transferFocus();
            }
            super.PreConsistenciaFazer();
        } else {
            this.setVisible(false);
            this.io_transaction_manager.io_datastore.TaxaEmbarqueFiltrar(false);
        }
    }

    protected VeSDecimal FixedValueGet() {
        return this.ParametersGet().in_taxa_embarque;
    }

    protected final void FixedValueSet(VeSDecimal an_value) {
        this.ParametersGet().in_taxa_embarque = an_value;
    }

    public void DadoConsistir() throws VeSPagueProcessamentoException, VeSPagueNoFocusChangeSign {
        String ls_valor_maximo;
        String ls_componente_nome = this.getName();
        String ls_valor_digitado = this.getText();
        if (ls_valor_digitado.isEmpty()) {
            ls_valor_digitado = "0,00";
            this.setText(ls_valor_digitado);
        }
        VeSDecimal ln_valor = new VeSDecimal(ls_valor_digitado, false, "0,00");
        VeSDecimal ln_valor_temp = this.ValorMinimoGet();
        String ls_valor_minimo = ln_valor_temp != null ? ln_valor_temp.format("###,###,###0.00") : null;
        ln_valor_temp = this.ValorMaximoGet();
        String string = ln_valor_temp != null ? ln_valor_temp.format("###,###,###0.00") : (ls_valor_maximo = this.io_transaction_manager.io_datastore.ContainsAcquirer(VeSPagueClientUtil.TRANSACAO_REDE_AMEX) ? null : this.io_transaction_manager.io_datastore.ValorVendaGet().format("###,###,###0.00"));
        if (ls_valor_minimo != null && ls_valor_maximo != null) {
            VeSPagueTransactionFieldUtil.IntervaloVerificar((Comparable)ln_valor, (Comparable)this.ValorMinimoGet(), (Comparable)this.io_transaction_manager.io_datastore.ValorVendaGet(), (String)VeSPagueMessageOld.MessageGet((int)1).toString(new Object[]{ls_componente_nome, ls_valor_minimo, ls_valor_maximo}), (String)VeSPagueMessageOld.MessageGet((int)4).toString(new Object[]{ls_componente_nome, ls_valor_minimo}), (String)VeSPagueMessageOld.MessageGet((int)5).toString(new Object[]{ls_componente_nome, ls_valor_maximo}));
        }
        this.io_transaction_manager.io_datastore.TaxaEmbarqueFiltrar(true);
    }

    public boolean isCollect() {
        boolean ib_collect = false;
        try {
            ib_collect = VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_FINANCIADO.equals(this.io_transaction_manager.TransactionGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_ENDERECO.equals(this.io_transaction_manager.TransactionGet().is_tipo) ? false : this.io_transaction_manager.io_datastore.TaxaEmbarqueNecessidadeVerificar();
        }
        catch (VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException ex) {
            ex.printStackTrace();
        }
        return ib_collect;
    }

    protected boolean MaximoDigitosPermitido(String as_valor_original) {
        return this.io_transaction_manager != null && this.ParametersGet() != null && this.io_transaction_manager.DatastoreGet() != null && this.io_transaction_manager.DatastoreGet().ContainsAcquirer(VeSPagueClientUtil.TRANSACAO_REDE_CIELO) ? as_valor_original.length() < 10 : super.MaximoDigitosPermitido(as_valor_original);
    }
}

